/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import edu.cornell.cs.cs2110.DelimitedStringBuilder;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import rubik.CubeGroup;
import rubik.Square;
import rubik.geometry.Matrix;
import rubik.geometry.ThreeDPoint;

public class Cube {
    static Map<ThreeDPoint, Cube> cubes = new HashMap<ThreeDPoint, Cube>();
    ThreeDPoint center;
    Square[] faces = new Square[6];
    CubeGroup position = CubeGroup.elements.get(Matrix.IDENTITY);
    CubeGroup oldPosition;
    Type type;
    static Cube centralCube;
    static final ThreeDPoint[] normals;
    static final Color[] colors;

    static {
        normals = new ThreeDPoint[]{new ThreeDPoint(1.0, 0.0, 0.0), new ThreeDPoint(-1.0, 0.0, 0.0), new ThreeDPoint(0.0, 1.0, 0.0), new ThreeDPoint(0.0, -1.0, 0.0), new ThreeDPoint(0.0, 0.0, 1.0), new ThreeDPoint(0.0, 0.0, -1.0)};
        colors = new Color[]{Color.WHITE, Color.YELLOW, Color.BLUE, Color.GREEN, Color.RED, new Color(255, 100, 0)};
    }

    static void create() {
        centralCube = new Cube(ThreeDPoint.ZERO, Type.CENTER);
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 2) {
                int k = -2;
                while (k <= 2) {
                    int t = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    if (t != 0) {
                        Type type = t == 6 ? Type.CORNER : (t == 4 ? Type.EDGE : Type.FACE);
                        new Cube(new ThreeDPoint(i, j, k), type);
                    }
                    k += 2;
                }
                j += 2;
            }
            i += 2;
        }
    }

    Cube(ThreeDPoint center, Type type) {
        this.type = type;
        this.center = center;
        int i = 0;
        while (i < 6) {
            this.faces[i] = new Square(this, center.plus(normals[i].scale(0.9999999999)), normals[i]);
            ++i;
        }
        this.setFaceColors();
        cubes.put(center, this);
    }

    void setFaceColors() {
        int i = 0;
        while (i < 6) {
            Color color = normals[i].cos(this.center) > 0.0 ? colors[i] : Color.BLACK;
            this.faces[i].setColor(color);
            ++i;
        }
    }

    static void setAllColors() {
        for (Cube c : cubes.values()) {
            c.setFaceColors();
        }
    }

    public String toString() {
        return String.format("type= %s center= %s\nposition=\n%s", this.type.toString(), this.center.toString(), this.position.toString());
    }

    static Cube cubeAt(int x, int y, int z) {
        return cubes.get(new ThreeDPoint(x, y, z));
    }

    static String encode() {
        DelimitedStringBuilder dsb = new DelimitedStringBuilder("\n");
        for (Cube c : cubes.values()) {
            dsb.append(c.toString());
        }
        int i = 0;
        while (i < colors.length) {
            Color c = colors[i];
            dsb.append(String.format("color %d = %d %d %d", i, c.getRed(), c.getGreen(), c.getBlue()));
            ++i;
        }
        return dsb.toString();
    }

    public int hashCode() {
        return this.center.hashCode();
    }

    public boolean equals(Object o) {
        try {
            return this.center.equals(((Cube)o).center);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    static void decode(Scanner sc) throws Exception {
        for (Cube c : cubes.values()) {
            sc.nextLine();
            sc.nextLine();
            Matrix m = new Matrix();
            m.x.x = sc.nextDouble();
            m.x.y = sc.nextDouble();
            m.x.z = sc.nextDouble();
            m.y.x = sc.nextDouble();
            m.y.y = sc.nextDouble();
            m.y.z = sc.nextDouble();
            m.z.x = sc.nextDouble();
            m.z.y = sc.nextDouble();
            m.z.z = sc.nextDouble();
            c.position = CubeGroup.elements.get(m);
            sc.nextLine();
        }
        int i = 0;
        while (i < colors.length) {
            sc.next();
            sc.next();
            sc.next();
            Cube.colors[i] = new Color(sc.nextInt(), sc.nextInt(), sc.nextInt());
            ++i;
        }
        sc.nextLine();
        if (sc.hasNext()) {
            throw new Exception();
        }
        Cube.setAllColors();
    }

    static enum Type {
        CORNER,
        EDGE,
        FACE,
        CENTER;

    }
}

