/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.util.HashMap;
import java.util.Map;
import rubik.BSPVisitor;
import rubik.Square;
import rubik.State;

class BSPTreeNode {
    static final BSPTreeNode xRoot = new BSPTreeNode();
    static final BSPTreeNode yRoot = new BSPTreeNode();
    static final BSPTreeNode zRoot = new BSPTreeNode();
    static final Map<State.Plane, BSPTreeNode> roots = new HashMap<State.Plane, BSPTreeNode>();
    private Square data = null;
    private BSPTreeNode back = null;
    private BSPTreeNode front = null;

    static {
        roots.put(State.Plane.FRONT, xRoot);
        roots.put(State.Plane.BACK, xRoot);
        roots.put(State.Plane.LEFT, yRoot);
        roots.put(State.Plane.RIGHT, yRoot);
        roots.put(State.Plane.UP, zRoot);
        roots.put(State.Plane.DOWN, zRoot);
    }

    public BSPTreeNode(Square s) {
        this.data = s;
    }

    public BSPTreeNode() {
    }

    public void insert(Square s) {
        if (this.data == null) {
            this.data = s;
        } else if (this.data.behind(s.center)) {
            if (this.front == null) {
                this.front = new BSPTreeNode(s);
            } else {
                this.front.insert(s);
            }
        } else if (this.back == null) {
            this.back = new BSPTreeNode(s);
        } else {
            this.back.insert(s);
        }
    }

    public <T> T enumerate(BSPVisitor<T> visitor, T accum) {
        if (this.data.behind(visitor.viewpoint(this.data))) {
            if (this.back != null) {
                accum = this.back.enumerate(visitor, accum);
            }
            accum = visitor.visit(this.data, accum);
            if (this.front != null) {
                accum = this.front.enumerate(visitor, accum);
            }
        } else {
            if (this.front != null) {
                accum = this.front.enumerate(visitor, accum);
            }
            accum = visitor.visit(this.data, accum);
            if (this.back != null) {
                accum = this.back.enumerate(visitor, accum);
            }
        }
        return accum;
    }
}

