/* The following code was generated by JFlex 1.5.1 */

/* Java 1.4 scanner for JFlex.
 * Based on JLS, 2ed, Chapter 3.
 */

package jif.parse;

import java_cup.runtime.Symbol;
import polyglot.lex.Lexer;
import polyglot.lex.*;
import polyglot.util.Position;
import polyglot.util.ErrorQueue;
import polyglot.util.ErrorInfo;
import polyglot.frontend.Source;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.5.1
 * from the specification file <tt>jif.flex</tt>
 */
public class Lexer_c implements Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int CHARACTER = 4;
  public static final int TRADITIONAL_COMMENT = 6;
  public static final int END_OF_LINE_COMMENT = 8;
  public static final int JAVADOC_COMMENT = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\74\1\75\1\2\16\5\4\0\1\3\1\50"+
    "\1\23\1\0\1\4\1\60\1\54\1\22\1\35\1\36\1\21\1\56"+
    "\1\44\1\15\1\13\1\20\1\6\3\17\4\12\2\7\1\53\1\43"+
    "\1\47\1\45\1\46\1\52\1\0\3\11\1\63\1\14\1\62\5\4"+
    "\1\61\13\4\1\10\2\4\1\41\1\16\1\42\1\57\1\4\1\0"+
    "\1\31\1\77\1\11\1\63\1\27\1\30\5\4\1\32\1\4\1\34"+
    "\3\4\1\25\1\33\1\24\1\26\2\4\1\10\2\4\1\37\1\55"+
    "\1\40\1\51\6\5\1\76\32\5\2\0\4\4\4\0\1\4\2\0"+
    "\1\5\7\0\1\4\4\0\1\4\5\0\27\4\1\0\37\4\1\0"+
    "\u01ca\4\4\0\14\4\16\0\5\4\7\0\1\4\1\0\1\4\21\0"+
    "\160\5\5\4\1\0\2\4\2\0\4\4\10\0\1\4\1\0\3\4"+
    "\1\0\1\4\1\0\24\4\1\0\123\4\1\0\213\4\1\0\5\5"+
    "\2\0\236\4\11\0\46\4\2\0\1\4\7\0\47\4\7\0\1\4"+
    "\1\0\55\5\1\0\1\5\1\0\2\5\1\0\2\5\1\0\1\5"+
    "\10\0\33\4\5\0\3\4\15\0\5\5\6\0\1\4\4\0\13\5"+
    "\5\0\53\4\37\5\4\0\2\4\1\5\143\4\1\0\1\4\10\5"+
    "\1\0\6\5\2\4\2\5\1\0\4\5\2\4\12\5\3\4\2\0"+
    "\1\4\17\0\1\5\1\4\1\5\36\4\33\5\2\0\131\4\13\5"+
    "\1\4\16\0\12\5\41\4\11\5\2\4\4\0\1\4\5\0\26\4"+
    "\4\5\1\4\11\5\1\4\3\5\1\4\5\5\22\0\31\4\3\5"+
    "\104\0\1\4\1\0\13\4\67\0\33\5\1\0\4\5\66\4\3\5"+
    "\1\4\22\5\1\4\7\5\12\4\2\5\2\0\12\5\1\0\7\4"+
    "\1\0\7\4\1\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\1\4\3\0\4\4\2\0\1\5\1\4\7\5"+
    "\2\0\2\5\2\0\3\5\1\4\10\0\1\5\4\0\2\4\1\0"+
    "\3\4\2\5\2\0\12\5\4\4\7\0\1\4\5\0\3\5\1\0"+
    "\6\4\4\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0"+
    "\2\4\1\0\2\4\2\0\1\5\1\0\5\5\4\0\2\5\2\0"+
    "\3\5\3\0\1\5\7\0\4\4\1\0\1\4\7\0\14\5\3\4"+
    "\1\5\13\0\3\5\1\0\11\4\1\0\3\4\1\0\26\4\1\0"+
    "\7\4\1\0\2\4\1\0\5\4\2\0\1\5\1\4\10\5\1\0"+
    "\3\5\1\0\3\5\2\0\1\4\17\0\2\4\2\5\2\0\12\5"+
    "\1\0\1\4\17\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\2\4\1\0\5\4\2\0\1\5\1\4\7\5"+
    "\2\0\2\5\2\0\3\5\10\0\2\5\4\0\2\4\1\0\3\4"+
    "\2\5\2\0\12\5\1\0\1\4\20\0\1\5\1\4\1\0\6\4"+
    "\3\0\3\4\1\0\4\4\3\0\2\4\1\0\1\4\1\0\2\4"+
    "\3\0\2\4\3\0\3\4\3\0\14\4\4\0\5\5\3\0\3\5"+
    "\1\0\4\5\2\0\1\4\6\0\1\5\16\0\12\5\11\0\1\4"+
    "\7\0\3\5\1\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4"+
    "\1\0\5\4\3\0\1\4\7\5\1\0\3\5\1\0\4\5\7\0"+
    "\2\5\1\0\2\4\6\0\2\4\2\5\2\0\12\5\22\0\2\5"+
    "\1\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4"+
    "\2\0\1\5\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5"+
    "\7\0\1\4\1\0\2\4\2\5\2\0\12\5\1\0\2\4\17\0"+
    "\2\5\1\0\10\4\1\0\3\4\1\0\51\4\2\0\1\4\7\5"+
    "\1\0\3\5\1\0\4\5\1\4\10\0\1\5\10\0\2\4\2\5"+
    "\2\0\12\5\12\0\6\4\2\0\2\5\1\0\22\4\3\0\30\4"+
    "\1\0\11\4\1\0\1\4\2\0\7\4\3\0\1\5\4\0\6\5"+
    "\1\0\1\5\1\0\10\5\22\0\2\5\15\0\60\4\1\5\2\4"+
    "\7\5\4\0\10\4\10\5\1\0\12\5\47\0\2\4\1\0\1\4"+
    "\2\0\2\4\1\0\1\4\2\0\1\4\6\0\4\4\1\0\7\4"+
    "\1\0\3\4\1\0\1\4\1\0\1\4\2\0\2\4\1\0\4\4"+
    "\1\5\2\4\6\5\1\0\2\5\1\4\2\0\5\4\1\0\1\4"+
    "\1\0\6\5\2\0\12\5\2\0\4\4\40\0\1\4\27\0\2\5"+
    "\6\0\12\5\13\0\1\5\1\0\1\5\1\0\1\5\4\0\2\5"+
    "\10\4\1\0\44\4\4\0\24\5\1\0\2\5\5\4\13\5\1\0"+
    "\44\5\11\0\1\5\71\0\53\4\24\5\1\4\12\5\6\0\6\4"+
    "\4\5\4\4\3\5\1\4\3\5\2\4\7\5\3\4\4\5\15\4"+
    "\14\5\1\4\17\5\2\0\46\4\1\0\1\4\5\0\1\4\2\0"+
    "\53\4\1\0\u014d\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0"+
    "\4\4\2\0\51\4\1\0\4\4\2\0\41\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\17\4\1\0\71\4\1\0"+
    "\4\4\2\0\103\4\2\0\3\5\40\0\20\4\20\0\125\4\14\0"+
    "\u026c\4\2\0\21\4\1\0\32\4\5\0\113\4\3\0\3\4\17\0"+
    "\15\4\1\0\4\4\3\5\13\0\22\4\3\5\13\0\22\4\2\5"+
    "\14\0\15\4\1\0\3\4\1\0\2\5\14\0\64\4\40\5\3\0"+
    "\1\4\3\0\2\4\1\5\2\0\12\5\41\0\3\5\2\0\12\5"+
    "\6\0\130\4\10\0\51\4\1\5\1\4\5\0\106\4\12\0\35\4"+
    "\3\0\14\5\4\0\14\5\12\0\12\5\36\4\2\0\5\4\13\0"+
    "\54\4\4\0\21\5\7\4\2\5\6\0\12\5\46\0\27\4\5\5"+
    "\4\0\65\4\12\5\1\0\35\5\2\0\13\5\6\0\12\5\15\0"+
    "\1\4\130\0\5\5\57\4\21\5\7\4\4\0\12\5\21\0\11\5"+
    "\14\0\3\5\36\4\15\5\2\4\12\5\54\4\16\5\14\0\44\4"+
    "\24\5\10\0\12\5\3\0\3\4\12\5\44\4\122\0\3\5\1\0"+
    "\25\5\4\4\1\5\4\4\3\5\2\4\11\0\300\4\47\5\25\0"+
    "\4\5\u0116\4\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4"+
    "\1\0\1\4\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4"+
    "\1\0\7\4\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4"+
    "\2\0\6\4\4\0\15\4\5\0\3\4\1\0\7\4\16\0\5\5"+
    "\30\0\1\74\1\74\5\5\20\0\2\4\23\0\1\4\13\0\5\5"+
    "\5\0\6\5\1\0\1\4\15\0\1\4\20\0\15\4\3\0\33\4"+
    "\25\0\15\5\4\0\1\5\3\0\14\5\21\0\1\4\4\0\1\4"+
    "\2\0\12\4\1\0\1\4\3\0\5\4\6\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\4\4\1\0\13\4\2\0\4\4\5\0\5\4"+
    "\4\0\1\4\21\0\51\4\7\0\1\66\1\0\1\67\352\0\1\72"+
    "\23\0\1\73\1\0\1\64\1\65\17\0\1\70\1\71\u095a\0\57\4"+
    "\1\0\57\4\1\0\205\4\6\0\4\4\3\5\2\4\14\0\46\4"+
    "\1\0\1\4\5\0\1\4\2\0\70\4\7\0\1\4\17\0\1\5"+
    "\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0"+
    "\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0\40\5\57\0"+
    "\1\4\u01d5\0\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4"+
    "\4\0\126\4\2\0\2\5\2\0\3\4\1\0\132\4\1\0\4\4"+
    "\5\0\51\4\3\0\136\4\21\0\33\4\65\0\20\4\u0200\0\u19b6\4"+
    "\112\0\u51cd\4\63\0\u048d\4\103\0\56\4\2\0\u010d\4\3\0\20\4"+
    "\12\5\2\4\24\0\57\4\1\5\4\0\12\5\1\0\31\4\7\0"+
    "\1\5\120\4\2\5\45\0\11\4\2\0\147\4\2\0\4\4\1\0"+
    "\4\4\14\0\13\4\115\0\12\4\1\5\3\4\1\5\4\4\1\5"+
    "\27\4\5\5\20\0\1\4\7\0\64\4\14\0\2\5\62\4\21\5"+
    "\13\0\12\5\6\0\22\5\6\4\3\0\1\4\4\0\12\5\34\4"+
    "\10\5\2\0\27\4\15\5\14\0\35\4\3\0\4\5\57\4\16\5"+
    "\16\0\1\4\12\5\46\0\51\4\16\5\11\0\3\4\1\5\10\4"+
    "\2\5\2\0\12\5\6\0\27\4\3\0\1\4\1\5\4\0\60\4"+
    "\1\5\1\4\3\5\2\4\2\5\5\4\2\5\1\4\1\5\1\4"+
    "\30\0\3\4\2\0\13\4\5\5\2\0\3\4\2\5\12\0\6\4"+
    "\2\0\6\4\2\0\6\4\11\0\7\4\1\0\7\4\221\0\43\4"+
    "\10\5\1\0\2\5\2\0\12\5\6\0\u2ba4\4\14\0\27\4\4\0"+
    "\61\4\u2104\0\u016e\4\2\0\152\4\46\0\7\4\14\0\5\4\5\0"+
    "\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0"+
    "\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0"+
    "\66\4\50\0\15\4\3\0\20\5\20\0\7\5\14\0\2\4\30\0"+
    "\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5\4\0"+
    "\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4\13\0"+
    "\131\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0"+
    "\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\2\2\1\3\2\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\3\3\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\1\45\1\46"+
    "\1\47\2\50\1\1\1\51\1\47\2\52\1\1\1\53"+
    "\1\2\2\54\2\55\1\56\2\0\1\57\1\0\1\60"+
    "\1\61\1\62\1\63\1\64\1\65\1\66\1\67\1\70"+
    "\3\3\1\71\1\72\1\73\1\74\1\75\1\76\1\77"+
    "\1\100\1\101\1\102\1\103\1\104\1\105\1\106\1\107"+
    "\2\110\1\111\1\112\1\113\1\114\1\115\1\116\1\117"+
    "\1\120\1\121\1\122\1\123\1\124\1\125\1\126\1\127"+
    "\1\130\1\131\1\132\1\133\1\57\1\0\1\134\3\3"+
    "\1\135\1\136\1\137\1\110\1\140\1\141\1\3\1\142"+
    "\1\143\1\144";

  private static int [] zzUnpackAction() {
    int [] result = new int[133];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u0180"+
    "\0\u01c0\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380"+
    "\0\u0180\0\u0180\0\u03c0\0\u0400\0\u0440\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0480\0\u04c0\0\u0500"+
    "\0\u0540\0\u0180\0\u0180\0\u0180\0\u0580\0\u05c0\0\u0600\0\u0640"+
    "\0\u0680\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u06c0\0\u0180\0\u0700\0\u0740\0\u0180\0\u0780\0\u0180"+
    "\0\u07c0\0\u0800\0\u0180\0\u0840\0\u0180\0\u0880\0\u0180\0\u08c0"+
    "\0\u0900\0\u0940\0\u0980\0\u09c0\0\u0a00\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0a40\0\u0180\0\u0180\0\u0a80\0\u0ac0"+
    "\0\u0b00\0\u0180\0\u0180\0\u0b40\0\u0180\0\u0b80\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180"+
    "\0\u0bc0\0\u0c00\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0c40\0\u0c80\0\u0cc0\0\u0180"+
    "\0\u0d00\0\u0d40\0\u0d80\0\u0180\0\u0dc0\0\u0180\0\u0180\0\u0180"+
    "\0\u0200\0\u0e00\0\u0200\0\u0180\0\u0200";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[133];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\1\11\1\10\1\12\1\7\1\13\1\14"+
    "\2\12\1\14\1\15\1\12\1\16\1\7\1\14\1\17"+
    "\1\20\1\21\1\22\1\23\3\12\1\24\3\12\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\3\12\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\7\1\10\1\7"+
    "\1\12\1\62\1\63\1\64\13\62\1\65\4\62\1\66"+
    "\54\62\1\67\1\70\1\71\13\67\1\72\3\67\1\73"+
    "\55\67\21\10\1\74\57\10\1\75\1\76\71\10\3\7"+
    "\1\10\21\77\1\100\56\77\101\0\1\10\102\0\7\12"+
    "\1\0\1\12\2\0\1\12\4\0\11\12\24\0\3\12"+
    "\12\0\2\12\6\0\1\101\1\102\1\103\1\0\1\101"+
    "\1\104\1\105\2\0\1\101\7\0\1\105\1\106\1\0"+
    "\1\107\26\0\1\107\1\106\1\110\22\0\2\14\2\0"+
    "\1\14\1\104\1\105\2\0\1\14\7\0\1\105\1\106"+
    "\1\0\1\107\26\0\1\107\1\106\1\110\22\0\2\104"+
    "\2\0\1\104\4\0\1\104\75\0\1\111\27\0\1\112"+
    "\52\0\1\113\1\114\23\0\1\115\77\0\1\116\36\0"+
    "\7\12\1\0\1\12\2\0\1\12\4\0\1\12\1\117"+
    "\7\12\24\0\3\12\12\0\2\12\4\0\7\12\1\0"+
    "\1\12\2\0\1\12\4\0\5\12\1\120\3\12\24\0"+
    "\3\12\12\0\2\12\4\0\7\12\1\0\1\12\2\0"+
    "\1\12\4\0\2\12\1\121\6\12\24\0\3\12\12\0"+
    "\2\12\45\0\1\122\77\0\1\123\1\124\76\0\1\125"+
    "\1\0\1\126\75\0\1\127\77\0\1\130\6\0\1\131"+
    "\70\0\1\132\7\0\1\133\67\0\1\134\10\0\1\135"+
    "\66\0\1\136\77\0\1\137\32\0\1\62\2\0\13\62"+
    "\1\0\4\62\1\0\54\62\1\0\1\63\76\0\1\140"+
    "\2\0\3\140\1\141\3\140\1\142\3\140\1\143\1\141"+
    "\2\140\1\144\1\145\1\146\1\147\2\140\1\150\3\140"+
    "\1\151\37\140\3\0\1\152\1\67\2\0\13\67\1\0"+
    "\3\67\1\0\55\67\1\0\1\70\76\0\1\140\2\0"+
    "\3\140\1\141\3\140\1\142\3\140\1\153\1\141\2\140"+
    "\1\154\1\155\1\156\1\157\2\140\1\160\3\140\1\161"+
    "\37\140\3\0\1\162\20\0\1\75\60\0\1\75\116\0"+
    "\1\163\65\0\1\101\1\102\2\0\1\101\1\104\1\105"+
    "\2\0\1\101\7\0\1\105\2\0\1\164\26\0\1\164"+
    "\24\0\2\102\2\0\1\102\1\104\1\105\2\0\1\102"+
    "\7\0\1\105\56\0\2\165\1\0\2\165\1\0\1\165"+
    "\2\0\1\165\7\0\3\165\30\0\2\165\13\0\1\165"+
    "\6\0\2\104\2\0\1\104\1\0\1\105\2\0\1\104"+
    "\7\0\1\105\1\106\31\0\1\106\1\110\22\0\2\166"+
    "\2\0\1\166\2\0\1\167\1\0\1\166\36\0\1\167"+
    "\42\0\1\170\62\0\7\12\1\0\1\12\2\0\1\12"+
    "\4\0\2\12\1\171\6\12\24\0\3\12\12\0\2\12"+
    "\4\0\7\12\1\0\1\12\2\0\1\12\4\0\6\12"+
    "\1\172\2\12\24\0\3\12\12\0\2\12\4\0\7\12"+
    "\1\0\1\12\2\0\1\12\4\0\6\12\1\173\2\12"+
    "\24\0\3\12\12\0\2\12\45\0\1\174\1\175\76\0"+
    "\1\176\40\0\1\142\3\0\1\142\4\0\1\142\66\0"+
    "\1\177\3\0\1\177\4\0\1\177\66\0\2\165\1\0"+
    "\2\165\1\0\1\165\2\0\1\165\7\0\3\165\1\200"+
    "\26\0\1\200\2\165\13\0\1\165\6\0\2\166\2\0"+
    "\1\166\4\0\1\166\10\0\1\106\31\0\1\106\1\110"+
    "\22\0\2\166\2\0\1\166\4\0\1\166\64\0\7\12"+
    "\1\0\1\12\2\0\1\12\4\0\3\12\1\201\5\12"+
    "\24\0\3\12\12\0\2\12\4\0\7\12\1\0\1\12"+
    "\2\0\1\12\4\0\7\12\1\202\1\12\24\0\3\12"+
    "\12\0\2\12\4\0\7\12\1\0\1\12\2\0\1\12"+
    "\4\0\6\12\1\203\2\12\24\0\3\12\12\0\2\12"+
    "\45\0\1\204\36\0\7\12\1\0\1\12\2\0\1\12"+
    "\4\0\3\12\1\205\5\12\24\0\3\12\12\0\2\12";

  private static int [] zzUnpackTrans() {
    int [] result = new int[3648];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\2\11\10\1\2\11\3\1\10\11\4\1\3\11"+
    "\5\1\10\11\1\1\1\11\2\1\1\11\1\1\1\11"+
    "\2\1\1\11\1\1\1\11\1\1\1\11\2\1\2\0"+
    "\1\1\1\0\6\11\1\1\2\11\3\1\2\11\1\1"+
    "\1\11\1\1\12\11\2\1\22\11\2\1\1\0\1\11"+
    "\3\1\1\11\1\1\3\11\3\1\1\11\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[133];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    StringBuffer sb = new StringBuffer();
    String file;
    String path;
    ErrorQueue eq;
    HashMap keywords;
    Position commentBegin;

    public Lexer_c(java.io.InputStream in, Source file, ErrorQueue eq) {
        this(new java.io.BufferedReader(new java.io.InputStreamReader(in)),
             file, eq);
    }

    public Lexer_c(java.io.Reader reader, Source file, ErrorQueue eq) {
        this(reader);
        this.file = file.name();
        this.path = file.path();
        this.eq = eq;
        this.keywords = new HashMap();
        init_keywords();
    }

    public Set<String> keywords() {
	if (keywords == null) {
	    keywords = new HashMap<>();
	    init_keywords();
	}

	return Collections.unmodifiableSet(keywords.keySet());
    }

    protected void init_keywords() {
        keywords.put("abstract",      new Integer(sym.ABSTRACT));
        keywords.put("assert",        new Integer(sym.ASSERT));
        keywords.put("boolean",       new Integer(sym.BOOLEAN));
        keywords.put("break",         new Integer(sym.BREAK));
        keywords.put("byte",          new Integer(sym.BYTE));
        keywords.put("case",          new Integer(sym.CASE));
        keywords.put("catch",         new Integer(sym.CATCH));
        keywords.put("char",          new Integer(sym.CHAR));
        keywords.put("class",         new Integer(sym.CLASS));
        keywords.put("const",         new Integer(sym.CONST));
        keywords.put("continue",      new Integer(sym.CONTINUE));
        keywords.put("default",       new Integer(sym.DEFAULT));
        keywords.put("do",            new Integer(sym.DO));
        keywords.put("double",        new Integer(sym.DOUBLE));
        keywords.put("else",          new Integer(sym.ELSE));
        keywords.put("extends",       new Integer(sym.EXTENDS));
        keywords.put("final",         new Integer(sym.FINAL));
        keywords.put("finally",       new Integer(sym.FINALLY));
        keywords.put("float",         new Integer(sym.FLOAT));
        keywords.put("for",           new Integer(sym.FOR));
        keywords.put("goto",          new Integer(sym.GOTO));
        keywords.put("if",            new Integer(sym.IF));
        keywords.put("implements",    new Integer(sym.IMPLEMENTS));
        keywords.put("import",        new Integer(sym.IMPORT));
        keywords.put("instanceof",    new Integer(sym.INSTANCEOF));
        keywords.put("int",           new Integer(sym.INT));
        keywords.put("interface",     new Integer(sym.INTERFACE));
        keywords.put("long",          new Integer(sym.LONG));
        keywords.put("native",        new Integer(sym.NATIVE));
        keywords.put("new",           new Integer(sym.NEW));
        keywords.put("package",       new Integer(sym.PACKAGE));
        keywords.put("private",       new Integer(sym.PRIVATE));
        keywords.put("protected",     new Integer(sym.PROTECTED));
        keywords.put("public",        new Integer(sym.PUBLIC));
        keywords.put("return",        new Integer(sym.RETURN));
        keywords.put("short",         new Integer(sym.SHORT));
        keywords.put("static",        new Integer(sym.STATIC));
        keywords.put("strictfp",      new Integer(sym.STRICTFP));
        keywords.put("super",         new Integer(sym.SUPER));
        keywords.put("switch",        new Integer(sym.SWITCH));
        keywords.put("synchronized",  new Integer(sym.SYNCHRONIZED));
        keywords.put("this",          new Integer(sym.THIS));
        keywords.put("throw",         new Integer(sym.THROW));
        keywords.put("throws",        new Integer(sym.THROWS));
        keywords.put("transient",     new Integer(sym.TRANSIENT));
        keywords.put("try",           new Integer(sym.TRY));
        keywords.put("void",          new Integer(sym.VOID));
        keywords.put("volatile",      new Integer(sym.VOLATILE));
        keywords.put("while",         new Integer(sym.WHILE));

        /* Jif-specific keywords */    
        keywords.put("actsFor",       new Integer(sym.ACTSFOR));
        keywords.put("actsfor",       new Integer(sym.ACTSFOR));
        keywords.put("equiv",         new Integer(sym.EQUIV));
        keywords.put("authority",     new Integer(sym.AUTHORITY));
        keywords.put("caller",        new Integer(sym.CALLER));
        keywords.put("covariant",     new Integer(sym.COVARIANT));
        keywords.put("invariant",     new Integer(sym.INVARIANT));
        keywords.put("declassify",    new Integer(sym.DECLASSIFY));
        keywords.put("endorse",       new Integer(sym.ENDORSE));
        keywords.put("to",            new Integer(sym.TO));
        keywords.put("label",         new Integer(sym.LABEL));
        keywords.put("principal",     new Integer(sym.PRINCIPAL));
        keywords.put("where",         new Integer(sym.WHERE));
        keywords.put("meet",          new Integer(sym.MEET));
        
        keywords.put("provider",     new Integer(sym.PROVIDER));        
    }

    public String file() {
        return file;
    }
    public String path() {
        return path;
    }

    private Position pos() {
        return new Position(path, file, yyline+1, yycolumn, yyline+1,
                            yycolumn + yytext().length(), yychar,
                            yychar + yytext().length());
    }

    private Position pos(int len) {
        return new Position(path, file, yyline+1, yycolumn-len-1, yyline+1,
                            yycolumn+1, yychar-len-1, yychar);
    }

    private Token key(int symbol) {
        return new Keyword(pos(), yytext(), symbol);
    }

    private Token op(int symbol) {
        return new Operator(pos(), yytext(), symbol);
    }

    private Token id() {
        return new Identifier(pos(), yytext(), sym.IDENTIFIER);
    }

    private Token int_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("2147483648"));
        int bits = radix == 10 ? 31 : 32;
        if (x.bitLength() > bits && ! boundary) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR, "Integer literal \"" +
                        yytext() + "\" out of range.", pos());
        }
        return new IntegerLiteral(pos(), x.intValue(),
                boundary ? sym.INTEGER_LITERAL_BD : sym.INTEGER_LITERAL);
    }

    private Token long_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("9223372036854775808"));
        int bits = radix == 10 ? 63 : 64;
        if (x.bitLength() > bits && ! boundary) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR, "Long literal \"" +
                        yytext() + "\" out of range.", pos());
        }
        return new LongLiteral(pos(), x.longValue(),
                boundary ? sym.LONG_LITERAL_BD : sym.LONG_LITERAL);
    }

    private Token float_lit(String s) {
        try {
            Float x = Float.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); i++) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') {
                    break; // 0e19 is still 0
                }
            }
            if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
                eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                           "Illegal float literal \"" + yytext() + "\"", pos());
            }
            return new FloatLiteral(pos(), x.floatValue(), sym.FLOAT_LITERAL);
        }
        catch (NumberFormatException e) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal float literal \"" + yytext() + "\"", pos());
            return new FloatLiteral(pos(), 0f, sym.FLOAT_LITERAL);
        }
    }

    private Token double_lit(String s) {
        try {
            Double x = Double.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); i++) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') {
                    break; // 0e19 is still 0
                }
            }
            if (x.isInfinite() || x.isNaN() || (x.doubleValue() == 0 && ! zero)) {
                eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                           "Illegal double literal \"" + yytext() + "\"", pos());
            }
            return new DoubleLiteral(pos(), x.doubleValue(), sym.DOUBLE_LITERAL);
        }
        catch (NumberFormatException e) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal double literal \"" + yytext() + "\"", pos());
            return new DoubleLiteral(pos(), 0., sym.DOUBLE_LITERAL);
        }
    }

    private Token char_lit(String s) {
        if (s.length() == 1) {
            char x = s.charAt(0);
            return new CharacterLiteral(pos(), x, sym.CHARACTER_LITERAL);
        }
        else {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal character literal \'" + s + "\'", pos(s.length()));
            return new CharacterLiteral(pos(), '\0', sym.CHARACTER_LITERAL);
        }
    }

    private Token boolean_lit(boolean x) {
        return new BooleanLiteral(pos(), x, sym.BOOLEAN_LITERAL);
    }

    private Token null_lit() {
        return new NullLiteral(pos(), sym.NULL_LITERAL);
    }

    private Token string_lit() {
        return new StringLiteral(pos(sb.length()), sb.toString(),
                                 sym.STRING_LITERAL);
    }
	
	private Token javadoc_token() {
		return new JavadocToken(pos(sb.length()), sb.toString(), sym.JAVADOC);
    }

    private String chop(int i, int j) {
        return yytext().substring(i,yylength()-j);
    }

    private String chop(int j) {
        return chop(0, j);
    }

    private String chop() {
        return chop(0, 1);
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer_c(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2292) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

    // numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Illegal character \"" +
                                              yytext() + "\"", pos());
          }
        case 101: break;
        case 2: 
          { /* ignore */
          }
        case 102: break;
        case 3: 
          { Integer i = (Integer) keywords.get(yytext());
                    if (i == null) return id();
                    else return key(i.intValue());
          }
        case 103: break;
        case 4: 
          { return int_lit(yytext(), 10);
          }
        case 104: break;
        case 5: 
          { return op(sym.DOT);
          }
        case 105: break;
        case 6: 
          { return op(sym.MINUS);
          }
        case 106: break;
        case 7: 
          { return op(sym.DIV);
          }
        case 107: break;
        case 8: 
          { return op(sym.MULT);
          }
        case 108: break;
        case 9: 
          { yybegin(CHARACTER); sb.setLength(0);
          }
        case 109: break;
        case 10: 
          { yybegin(STRING); sb.setLength(0);
          }
        case 110: break;
        case 11: 
          { return op(sym.LPAREN);
          }
        case 111: break;
        case 12: 
          { return op(sym.RPAREN);
          }
        case 112: break;
        case 13: 
          { return op(sym.LBRACE);
          }
        case 113: break;
        case 14: 
          { return op(sym.RBRACE);
          }
        case 114: break;
        case 15: 
          { return op(sym.LBRACK);
          }
        case 115: break;
        case 16: 
          { return op(sym.RBRACK);
          }
        case 116: break;
        case 17: 
          { return op(sym.SEMICOLON);
          }
        case 117: break;
        case 18: 
          { return op(sym.COMMA);
          }
        case 118: break;
        case 19: 
          { return op(sym.EQ);
          }
        case 119: break;
        case 20: 
          { return op(sym.GT);
          }
        case 120: break;
        case 21: 
          { return op(sym.LT);
          }
        case 121: break;
        case 22: 
          { return op(sym.NOT);
          }
        case 122: break;
        case 23: 
          { return op(sym.COMP);
          }
        case 123: break;
        case 24: 
          { return op(sym.QUESTION);
          }
        case 124: break;
        case 25: 
          { return op(sym.COLON);
          }
        case 125: break;
        case 26: 
          { return op(sym.AND);
          }
        case 126: break;
        case 27: 
          { return op(sym.OR);
          }
        case 127: break;
        case 28: 
          { return op(sym.PLUS);
          }
        case 128: break;
        case 29: 
          { return op(sym.XOR);
          }
        case 129: break;
        case 30: 
          { return op(sym.MOD);
          }
        case 130: break;
        case 31: 
          { return op(sym.MEET);
          }
        case 131: break;
        case 32: 
          { return op(sym.JOIN);
          }
        case 132: break;
        case 33: 
          { return op(sym.LEFTARROW);
          }
        case 133: break;
        case 34: 
          { return op(sym.RIGHTARROW);
          }
        case 134: break;
        case 35: 
          { return op(sym.TOP);
          }
        case 135: break;
        case 36: 
          { return op(sym.BOTTOM);
          }
        case 136: break;
        case 37: 
          { return op(sym.TRUST_GTEQ);
          }
        case 137: break;
        case 38: 
          { return op(sym.INFO_LTEQ);
          }
        case 138: break;
        case 39: 
          { sb.append( yytext() );
          }
        case 139: break;
        case 40: 
          { yybegin(YYINITIAL);
                                   eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Unclosed string literal",
                                              pos(sb.length()));
          }
        case 140: break;
        case 41: 
          { yybegin(YYINITIAL);
                                   return string_lit();
          }
        case 141: break;
        case 42: 
          { yybegin(YYINITIAL);
                                  eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                             "Unclosed character literal",
                                             pos(sb.length()));
          }
        case 142: break;
        case 43: 
          { yybegin(YYINITIAL);
                                   return char_lit(sb.toString());
          }
        case 143: break;
        case 44: 
          { yybegin(YYINITIAL);
          }
        case 144: break;
        case 45: 
          { sb.append(yytext());
          }
        case 145: break;
        case 46: 
          { return int_lit(yytext(), 8);
          }
        case 146: break;
        case 47: 
          { return double_lit(yytext());
          }
        case 147: break;
        case 48: 
          { return float_lit(chop());
          }
        case 148: break;
        case 49: 
          { return long_lit(chop(), 10);
          }
        case 149: break;
        case 50: 
          { return double_lit(chop());
          }
        case 150: break;
        case 51: 
          { return op(sym.MINUSMINUS);
          }
        case 151: break;
        case 52: 
          { return op(sym.MINUSEQ);
          }
        case 152: break;
        case 53: 
          { yybegin(END_OF_LINE_COMMENT);
          }
        case 153: break;
        case 54: 
          { yybegin(TRADITIONAL_COMMENT);
          }
        case 154: break;
        case 55: 
          { return op(sym.DIVEQ);
          }
        case 155: break;
        case 56: 
          { return op(sym.MULTEQ);
          }
        case 156: break;
        case 57: 
          { return op(sym.EQEQ);
          }
        case 157: break;
        case 58: 
          { return op(sym.GTEQ);
          }
        case 158: break;
        case 59: 
          { return op(sym.RSHIFT);
          }
        case 159: break;
        case 60: 
          { return op(sym.LTEQ);
          }
        case 160: break;
        case 61: 
          { return op(sym.LSHIFT);
          }
        case 161: break;
        case 62: 
          { return op(sym.NOTEQ);
          }
        case 162: break;
        case 63: 
          { return op(sym.ANDEQ);
          }
        case 163: break;
        case 64: 
          { return op(sym.ANDAND);
          }
        case 164: break;
        case 65: 
          { return op(sym.OREQ);
          }
        case 165: break;
        case 66: 
          { return op(sym.OROR);
          }
        case 166: break;
        case 67: 
          { return op(sym.PLUSEQ);
          }
        case 167: break;
        case 68: 
          { return op(sym.PLUSPLUS);
          }
        case 168: break;
        case 69: 
          { return op(sym.XOREQ);
          }
        case 169: break;
        case 70: 
          { return op(sym.MODEQ);
          }
        case 170: break;
        case 71: 
          { eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Illegal escape character \"" +
                                              yytext() + "\"", pos());
          }
        case 171: break;
        case 72: 
          { try {
                                       int x = Integer.parseInt(chop(1,0), 8);
                                       sb.append((char) x);
                                   }
                                   catch (NumberFormatException e) {
                                       eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                                  "Illegal octal escape \""
                                                  + yytext() + "\"", pos());
                                   }
          }
        case 172: break;
        case 73: 
          { sb.append( '\\' );
          }
        case 173: break;
        case 74: 
          { sb.append( '\'' );
          }
        case 174: break;
        case 75: 
          { sb.append( '\"' );
          }
        case 175: break;
        case 76: 
          { sb.append( '\t' );
          }
        case 176: break;
        case 77: 
          { sb.append( '\r' );
          }
        case 177: break;
        case 78: 
          { sb.append( '\f' );
          }
        case 178: break;
        case 79: 
          { sb.append( '\n' );
          }
        case 179: break;
        case 80: 
          { sb.append( '\b' );
          }
        case 180: break;
        case 81: 
          { sb.append('\\');
          }
        case 181: break;
        case 82: 
          { sb.append('\'');
          }
        case 182: break;
        case 83: 
          { sb.append('\"');
          }
        case 183: break;
        case 84: 
          { sb.append('\t');
          }
        case 184: break;
        case 85: 
          { sb.append('\r');
          }
        case 185: break;
        case 86: 
          { sb.append('\f');
          }
        case 186: break;
        case 87: 
          { sb.append('\n');
          }
        case 187: break;
        case 88: 
          { sb.append('\b');
          }
        case 188: break;
        case 89: 
          { yybegin(YYINITIAL);
    							   sb.append(yytext()); 
    							   return javadoc_token();
          }
        case 189: break;
        case 90: 
          { return long_lit(chop(), 8);
          }
        case 190: break;
        case 91: 
          { return int_lit(chop(2,0), 16);
          }
        case 191: break;
        case 92: 
          { yybegin(JAVADOC_COMMENT);
              sb.setLength(0);
              sb.append(yytext());
              commentBegin = pos();
          }
        case 192: break;
        case 93: 
          { return op(sym.RSHIFTEQ);
          }
        case 193: break;
        case 94: 
          { return op(sym.URSHIFT);
          }
        case 194: break;
        case 95: 
          { return op(sym.LSHIFTEQ);
          }
        case 195: break;
        case 96: 
          { return long_lit(chop(2,1), 16);
          }
        case 196: break;
        case 97: 
          { return boolean_lit(true);
          }
        case 197: break;
        case 98: 
          { return null_lit();
          }
        case 198: break;
        case 99: 
          { return op(sym.URSHIFTEQ);
          }
        case 199: break;
        case 100: 
          { return boolean_lit(false);
          }
        case 200: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JAVADOC_COMMENT: {
              yybegin(YYINITIAL);
                                   eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                                  "Unclosed Javadoc comment",
                                                  commentBegin);
            }
            case 134: break;
            default:
              {     return new EOF(pos(), sym.EOF);
 }
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
