function P = RandomProtein(n)
% Generates a "random" protein consisting of n amino acids.
% P is a length 3n string that encodes the protein.

% Concatenation of the 61 possible amino acids...
ListOfAA = ['GCTGCCGCAGCGCGTCGCCGACGGAGAAGGAATAACGATGACTGT'...
            'TGCCAACAGGAAGAGGGTGGCGGAGGGCATCACATTATCATACTT'...
            'CTCCTACTGTTATTGAAAAAGATGTTTTTCCCTCCCCCACCGTCT'...
            'TCCTCATCGAGTAGCACTACCACAACGTGGTATTACGTTGTCGTAGTG'];
P = '';
for k=1:n
    % Randomly select the next amino acid...
    i = ceil(61*rand(1)); 
    nextAA = ListOfAA(3*(i-1)+1:3*i);
    % and incorporate it into P...
    P = [P nextAA];
end