function a = FindMnenomic(s)
% s is a 3-character string that specifies an amino acid.
% a is the amino acid's 3-letter mnenomic.

C = CodonDictionary();
k = 1;
while strcmp(s,C(k,1:3))==0
    k=k+1;
end
a = C(k,5:7);

function C = CodonDictionary()
% C is a 61-by-7 character array.
% For k=1:61, C(k,1:3) specifies a codon and C(k,5:7) is the 
%   corresponding amino acid.

C = [ 'ATT Ile' ; 'ATC Ile' ; 'ATA Ile' ;...
      'CTT Leu' ; 'CTC Leu' ; 'CTA Leu' ; 'CTG Leu' ; 'TTA Leu' ; 'TTG Leu' ;...
      'GTT Val' ; 'GTC Val' ; 'GTA Val' ; 'GTG Val';...
      'TTT Phe' ; 'TTC Phe' ;...
      'ATG Met' ; ...
      'TGT Cys' ; 'TGC Cys' ;...
      'GCT Ala' ; 'GCC Ala' ; 'GCA Ala' ; 'GCG Ala' ;...
      'GGT Gly' ; 'GGC Gly' ; 'GGA Gly' ; 'GGG Gly' ;...
      'CCT Pro' ; 'CCC Pro' ; 'CCA Pro' ; 'CCG Pro' ;...
      'ACT Thr' ; 'ACC Thr' ; 'ACA Thr' ; 'ACG Thr' ;...
      'TCT Ser' ; 'TCC Ser' ; 'TCA Ser' ; 'TCG Ser' ; 'AGT Ser' ; 'AGC Ser' ;...
      'TAT Tyr' ; 'TAC Tyr' ;...
      'TGG Trp' ;...
      'CAA Glu' ; 'CAG Glu' ;...
      'AAT Asn' ; 'AAC Asn' ;...
      'CAT His' ; 'CAC His' ;...
      'GAA Gln' ; 'GAG Gln' ;...
      'GAT Asp' ; 'GAC Asp' ;...
      'AAA Lys' ; 'AAG Lys' ;... 
      'CGT Arg' ; 'CGC Arg' ; 'CGA Arg' ; 'CGG Arg' ; 'AGA Arg' ; 'AGG Arg'];