function City = Capitals
% Creates a length 48 structure array where each component
% has three fields:
%    Name   a length 24 string with the state and capital city's name
%    Lat    latitude in degress
%    Long   longitude in degrees
A = [...
      'AL  Montgomery          32.38     86.37';...
      'AZ  Phoenix             33.43    112.22';...
      'AR  Little Rock         34.73     92.23';...
      'CA  Sacramento          38.52    121.50';...
      'CO  Denver              39.75    104.87';...
      'CT  Hartford            41.78     72.78';...
      'DE  Dover               39.17     75.53';...
      'FL  Tallahassee         30.38     84.37';...
      'GA  Atlanta             33.75     84.38';...
      'ID  Boise               43.57    116.22';...
      'IL  Springfield         39.83     89.67';...
      'IN  Indianapolis        39.73     86.28';...
      'IA  Des Moines          41.53     93.65';...
      'KS  Topeka              39.77     95.63';...
      'KY  Frankfurt           38.20     84.88';...
      'LA  Baton Rouge         30.53     91.15';...
      'ME  Augusta             44.30     69.77';...
      'MA  Boston              42.37     71.33';...
      'MD  Annapolis           38.97     76.49';...
      'MI  Lansing             42.78     84.60';...
      'MN  St.Paul             44.88     93.22';...
      'MS  Jackson             32.32     90.88';...
      'MO  Jefferson City      38.57     92.18';...
      'MT  Helena              46.60    112.00';...
      'NE  Lincoln             40.85     96.75';...
      'NV  Carson City         39.17    119.77';...
      'NH  Concord             43.20     71.50';...
      'NJ  Trenton             40.22     74.77';...
      'NM  Santa Fe            35.62    106.88';...
      'NY  Albany              42.75     73.80';...
      'NC  Raleigh             35.87     78.78';...
      'ND  Bismarck            46.77    100.75';...
      'OH  Columbus            40.00     82.88';...
      'OK  Oklahoma City       35.40     97.60';...
      'OR  Salem               44.92    123.33';...
      'PA  Harrisburg          40.20     76.77';...
      'RI  Providence          41.73     71.43';...
      'SC  Columbia            34.00     81.55';...
      'SD  Pierre              44.38    100.28';...
      'TN  Knoxville           35.82     83.98';...
      'TX  Austin              30.30     97.70';...
      'UT  Salt Lake City      40.77    111.97';...
      'VT  Montpelier          44.25     72.58';...
      'VA  Richmond            37.50     77.33';...
      'WA  Olympia             46.97    122.90';...
      'WI  Madison             43.77     89.40';...
      'WV  Charleston          38.37     81.60';...
      'WY  Cheyenne            41.15    104.80'];
      
for k=1:48
    Lat  = str2num(A(k,25:29));
    Long = str2num(A(k,34:39));
    City(k) = struct('Name',A(k,1:24),'Lat',Lat,'Long',Long);
end


        
        


