

/* CS211 Final Project

 * Author: Max Khavin

 * TokenType.java

 ***************************************************************

 * This class contains public constants for identifying different

 * reserved words and operators of the Java programming language.

 * Not all of these words are even implemented as of now, but I

 * included them for the reasons of completeness.  Anything that

 * this class does not have is returned as IDENTIFIER.

 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 * DO NOT use the numbers for your comparisions, as they may change.

 * Get in the habit of using constants that are defined for you.

 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 */



public class TokenType {

  public final static int IDENTIFIER = -1;

  public final static int VARIABLES_START = -9; 

  public final static int METHODS_START = -10;

  public final static int ABSTRACT = 1;

  public final static int BREAK = 3;

  public final static int CASE = 5;

  public final static int CATCH = 6;

  public final static int CLASS = 8;

  public final static int CONST = 9;

  public final static int CONTINUE = 10;

  public final static int DO = 11;

  public final static int ELSE = 13;

  public final static int EXTENDS = 14;

  public final static int FINAL = 15;

  public final static int FINALLY = 16;

  public final static int FOR = 18;

  public final static int DEFAULT = 19;

  public final static int IF = 20;

  public final static int IMPLEMENTS = 21;

  public final static int IMPORT = 22;

  public final static int INSTANCEOF = 23;

  public final static int INTERFACE = 25;

  public final static int NATIVE = 27;

  public final static int NEW = 28;

  public final static int GOTO = 29;

  public final static int PUBLIC = 30;

  public final static int SUPER = 32;

  public final static int SWITCH = 33;

  public final static int SYNCHRONIZED = 34;

  public final static int PACKAGE = 35;

  public final static int THIS = 36;

  public final static int PRIVATE = 37;

  public final static int PROTECTED = 38;

  public final static int TRANSIENT = 39;

  public final static int RETURN = 40;

  public final static int TRY = 41;

  public final static int STATIC = 43;

  public final static int VOLATILE = 44;

  public final static int WHILE = 45;

  public final static int THROW = 46;

  public final static int THROWS = 47;

  public final static int LPARAN = 48;

  public final static int RPARAN = 49;

  public final static int LCURLY = 50;

  public final static int RCURLY = 51;

  public final static int LBRACKET = 52;

  public final static int RBRACKET = 53;

  public final static int SEMICOLON = 54;

  public final static int COLON = 55;

  public final static int TRUE = 56;

  public final static int FALSE = 57;

  public final static int NULL = 58;

  public final static int COMMA = 59;

  public final static int NUMBER = 100;

  public final static int STRING = 101;

  public final static int OPERATOR = 200;

}

