/***
* CS211 Final Project, Spring 1998
* Dan Grossman
* GUI for students
* DuckWidget.java
*/

import java.io.*;
import java.awt.*;
import java.awt.event.*;

class DuckWidget extends CloseableFrame implements 
	ActionListener, TextListener {

    // Some fonts for general use; instantiated in the constructor.
    private Font labelFont, buttonFont, dialogFont;

    // Various GUI components (buttons, panels, etc).
    private TextField tfName;
    private Button bQuit, bGo;
    private final int NumPanels = 2;
    private Panel pName, pGoQuit;
    
    private Label lName;

    // The name of the class, as set by the user.
    private String Name = "";
    
    // Constructor.  Mostly just sets up the GUI to look right.
    public DuckWidget () {
		// How big it is.
		setSize (700, 100);

		// Some fonts.
		labelFont = new Font ("SansSerif", Font.BOLD, 14);
		buttonFont = new Font ("SansSerif", Font.PLAIN, 12);
		dialogFont = new Font ("SansSerif", Font.PLAIN, 14);

		setTitle ("Duckument a File!");

		setLayout (new GridLayout(NumPanels, 1));

		pName = new Panel ();
		pName.setFont (labelFont);
		Label lName = new Label ("Class name:");
		lName.setFont (labelFont);
		pName.add (lName);
		tfName = new TextField (64);
		tfName.addTextListener (this);
		pName.add (tfName);
		add(pName);

		pGoQuit = new Panel();
		pGoQuit.setFont(labelFont);
		bGo = new Button("Go!");
		bGo.addActionListener(this);
		bGo.setEnabled (false);
		pGoQuit.add(bGo);
		bQuit = new Button ("Quit");
		bQuit.addActionListener(this);
		pGoQuit.add(bQuit);
		add (pGoQuit);
    }


    // Are we ready?  Check if all of the options have
    // been selected bythe user.
    private boolean readyToGo () {
		return !(Name.equals(""));	
    }



    // This routine handles the various user input events (button presses,
    // etc)
    public void actionPerformed (ActionEvent evt) {
		String arg = evt.getActionCommand();
		if (arg.equals(bGo.getLabel())) {
	    	// If it was the go button that was pressed then we're off.
	    	// The following check is redundant, as the Go button should
	    	// only be enabled if all is ready.
	    	if (readyToGo ()) {
				System.out.println ("All ready!");
	    	} else {
				System.out.println ("Not ready yet!");
	    	}
	    
		    // do it!
		    try {
		    	bGo.setEnabled(false);
		    	Documenter d = new Documenter();
			    d.documentClass(Name); // what it must be called
			    bGo.setEnabled(true);
			} catch (IOException e) {
				System.err.println("IO Exception while trying to document "
									+ Name);
			}

		} else if (arg.equals (bQuit.getLabel())) {
		    // Gracefully exit if the user asks to quit.
	    	System.exit(1);
		} else {
		    // This should never occur.  Left in as a debugging check.
	    	System.out.println("Some other action was performed.");
		}
    }


    public void textValueChanged(TextEvent e) {
		Name = tfName.getText().trim();
		if (readyToGo())
			bGo.setEnabled (true);
		else 
			bGo.setEnabled (false);
	}


    // A simple main program is all that's required!
    public static void main (String [] args) {
		Frame f = new DuckWidget();
		f.show();
    }
}

