/* parseHeader.c

   Parse header words for objects to make sure they are okay.

   */

#include "header.h"
#include <stdio.h>

typedef unsigned int Word;

void main(void)
{
 int header;

 header = 1;
 while(1)
   {
     printf("\nHeader(Decimal)? ");
     scanf("%d",&header);
     fflush(stdin);

     if(header==0) break;

     switch(GC_EXTRACT_STATUS(header))
	    {
	    case GC_MOVED:
	      {
		printf("\n\tStatus = Moved to %p\n",(unsigned int *)header);
		continue;
	      }
	    case GC_TRAVERSED:
	      {
		printf("\n\tStatus = Traversed\n");
		break;
	      }
	    case GC_PINNED:
	      {
		printf("\n\tStatus = Pinned\n");
		break;
	      }
	    case GC_NORMAL:
	      {
		printf("\n\tStatus = Normal\n");
		break;
	      }
	    }
	    
     switch(GC_EXTRACT_TYPE(header))
       {
       case GC_LARGE_RECORD:
	 {
	   printf("\tLarge Record:\n");
	   printf("\t\t Size = %d\n",GC_SIZE_LARGE(header));
	   if(!GC_END_LARGE(header))
	     {
	       printf("\t\t Header Words = %d\n",
		      GC_HEADER_WORDS_LARGE(header)); 
	     }
	   else
	     {
	       printf("\t\t End Marker.\n");
	     }
	 }
       case GC_RECORD:
	 {
	       printf("\tSmall Record:\n");
	       printf("\t\t Size = %d\n",GC_SIZE_SMALL(header));
	       printf("\t\t Bitmask = %x\n",GC_BITMASK_SMALL(header));
	   break;
	 }
       case GC_ARRAY:
	 {
	   printf("\tArray:\n");
	   printf("\t\t Size = %d\n",GC_SIZE_ARRAY(header));
	   printf("\t\t Pointer Array = %1d, Double Array = %1d\n",
		  (GC_POINTER_ARRAY(header) ? 1 : 0), (GC_DOUBLE_ARRAY(header) ?
						       1 : 0));
	   break;
	 }
       case GC_COBJ:
	 {
	   printf("\tC-Object:\n");
	   printf("\t\t Size = %d\n",GC_SIZE_COBJ(header));
	   printf("\t\t Pointer Free = %d\n", (GC_POINTER_FREE_COBJ(header) ? 1
					       : 0));
	   break;
	 }
       }
   }
}

/* EOF: parseHeader.c */

/* (c) Frederick Smith, Greg Morrisett.
 *     October 1998, all rights reserved.
 *
 *
 *              Copyright 1990-1993 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       250 University Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
