/* pageHeader.h */

#ifndef __PAGE_HEADER_H
#define __PAGE_HEADER_H

/* Pages are either free or in use.  Pages that are used can either be reserved
   , in from space, in to space or system pages. The top 10 bits record the
   position of the first header word on the page. If the result needs 10 bits
   there are no header words on this page. */

/* Page defines ....... */
#define PAGE_FREE 0
#define PAGE_RESERVED 1
#define PAGE_USER 2
#define PAGE_SYSTEM 4
#define PAGE_PINNED 8
#define PAGE_OLD 16
#define PAGE_MODIFIED 32
#define PAGE_BLACKLISTED 64
#define PAGE_BITMASK_UPDATED 128

#define OFFSET_SHIFT (WORD_SIZE - LOG_PAGE_SIZE - 1)
#define OFFSET_MASK  (ALL_ONES << OFFSET_SHIFT)

#define PAGE_OFFSET_HEADER(X) ((X) >> (OFFSET_SHIFT))

/* Set page header word X to have offset Y.  Does not affect other bits in X. */
#define PAGE_SET_OFFSET(X,Y) ((X) = (((X) & (~(OFFSET_MASK))) | (Y<<OFFSET_SHIFT)))

#define PAGE_PIN(X) ((X) |= PAGE_PINNED)
#define PAGE_UNPIN(X) ((X) &= ~PAGE_PINNED)

#define NO_HEADER_OFFSET (PAGE_SIZE + 1)

/* If a page is in fromSpace, returns true if its pinned. */
#define PAGE_IS_PINNED(X) ((X) & PAGE_PINNED)

#define PAGE_MARK(X) ((X) = (X) | PAGE_MODIFIED)
#define PAGE_UNMARK(X) ((X) = (X) & (~PAGE_MODIFIED))
#define PAGE_MARKED(X) ((X) & PAGE_MODIFIED)

#define PAGE_AGED(X) ((X) & PAGE_OLD)
#define PAGE_AGE(X) ((X) = ((X) | PAGE_OLD))
#define PAGE_UNAGE(X) ((X) = ((X) & ~PAGE_OLD))

#define PAGE_BLACKLIST(X) ((X) = (X) | PAGE_BLACKLISTED)
#define PAGE_IS_BLACKLISTED(X) ((X) & PAGE_BLACKLISTED)

#endif
/* EOF: pageHeader.h */

/* (c) Frederick Smith, Greg Morrisett.
 *     October 1998, all rights reserved.
 *
 *
 *              Copyright 1990-1993 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       250 University Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
