/* machine.h

   Machine dependencies. 

 */

#ifndef __MACHINE_H
#define __MACHINE_H

/* STATIC BASE < STATIC_TOP */
/* Following for SUNOS4 */
extern unsigned etext;
extern unsigned end;

#define OS_TYPE "SUNOS5"
#define MACHINE_TYPE "M68K"

#define STATIC_BASE gcInfo.staticBoundary
#define STATIC_TOP &end

#define STACK_BOTTOM asm("mov %%fp, %0" : "=r" (gcInfo.stackBottom))
#define STACK_TOP(X) asm("mov %%sp, %0" : "=r" (X))

#define GC_INIT(X) STACK_BOTTOM; gcInit(X); \
                   clearStackWords(STACK_INITIAL_CLEARANCE)


/* STACK_INCREASING defined means stackTop > stackBottom */
/* #define STACK_INCREASING */

#ifdef STACK_INCREASING
#define STACK_SIZE ((int)(gcInfo.stackTop - gcInfo.stackBottom))
#else
#define STACK_SIZE ((int)(gcInfo.stackBottom - gcInfo.stackTop))
#endif

/* Words to clear the first time we clear the stack. */
#define STACK_INITIAL_CLEARANCE 100000
/* Words to clear each time we clear the stack. */
#define STACK_CLEARANCE 5000
/* How much to decrement stackCleared each iteration. */
#define STACK_SLOP 128

#define PUSH_REGS asm("ta 0x3")

#endif

/* EOF: machine.h */
/* (c) Frederick Smith, Greg Morrisett.
 *     October 1998, all rights reserved.
 *
 *
 *              Copyright 1990-1993 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       250 University Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
