package JavaGroups.VideoConference.Media.Playback;

import java.io.*;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceStream;

public class MediaSourceStream implements PullSourceStream
{
   protected InputStream dataIn;
   protected boolean eofMarker;
   protected ContentDescriptor cd;

   public MediaSourceStream(InputStream in)
   {
      this.dataIn = in;
      eofMarker = false;
      cd = new ContentDescriptor("audio.basic");
	 }
   // SourceSteam methods
   public ContentDescriptor getContentDescriptor()
   {
      return cd;
   }

   public void close() throws IOException
   {
      dataIn.close();
   }

   public boolean endOfStream()
   {
      return eofMarker;
   }

   // PullSourceStream methods
   public int available() throws IOException
   {
      return dataIn.available();
   }

   public int read(byte[] buffer, int offset, int length) throws 
IOException
   {
		 	System.out.println("Number of bytes available from SourceStream = " + dataIn.available());
      int n = dataIn.read(buffer, offset, length);
			System.out.println("Number of bytes read from SourceStream=" + n);
			System.out.println("After read, # of bytes available from SourceStream = " + dataIn.available());
      if (n == -1)
      {
         eofMarker = true;
      }
      return n;
   }

	 public boolean willReadBlock()// throws IOException
	 {
		 if(eofMarker) 
		 {
			 return true;
		 } 
		 else 
		 {
			 try{
				 return dataIn.available() == 0;
			 }catch(IOException e){
				 e.printStackTrace();
				 return false;
			 }
		 }
	 }

   public long getContentLength()
   {
      return SourceStream.LENGTH_UNKNOWN;
   }
	 
	 public Object[] getControls(){
		 System.out.println("MediaSourceStream getControls[]");
		 return null;
	 }
	 public Object getControl(String str){
		 System.out.println("MediaSourceStream getControl with string:" +str);
		 return null;
	 }
}
