package JavaGroups.VideoConference.Media.Playback;

/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * MediaPlay is used by AudioManager, VideoManager to display the data they received
 * Note that JMF 1.1 player is used in version 0.5
 ******************************************************************************/


// The java media packages
import javax.media.*;
import javax.swing.*;
// Java platform packages
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import JavaGroups.VideoConference.GUI.*;
import JavaGroups.VideoConference.ControlManager.*;

public class MediaPlayer implements ControllerListener {

	/*************************************************************************
	 * VARIABLES
	 *************************************************************************/
	static Player player = null;
	Player newPlayer = null;
	static double defaultScale = 1.0;
	GUIManager guiManager=null;
	UserInfoManager userInfoManager=null;
	Component controlComp = null;		      // Controlpanel component
	Component visualComp = null;		      // Visual Component
	Component progressBar = null;		      // Cache indicator
	JPanel framePanel;				      // Panel to hold the above components
	JInternalFrame mediaFrame;
	Container contentPane;
	Insets insets;
	Menu menu;
	PopupMenu zoomMenu = null;
	//	OpenURLDialog urlDialog = null;
	CheckboxMenuItem cbAutoLoop = null;
	boolean windowCreated = false;
	boolean newVideo = false;
	boolean panelResized = false;
	static int listenPort = 4000;
	String filename = "SourceUnknown";
	String fileDirectory = ".";
	Object myAddress=null;
	
	static int windowCount = 0;			      // No. of windows currently open
	/*************************************************************************
	* METHODS
	*************************************************************************/

	/**
	 * Create the GUI and initialize the player
	 */
	public MediaPlayer(Player player, String media,GUIManager guiManager,UserInfoManager userInfoManager,Object src) {
		this.guiManager=guiManager;
		this.player = player;
		this.userInfoManager=userInfoManager;
		windowCount++;
		myAddress=userInfoManager.getMyUserInfo().getAddress();
		System.out.println("src is :"+src);
		if(media.equals("video")){
			if(myAddress.equals(src)){
				mediaFrame=guiManager.getMediaPanel().getMyNewVideoFrame();
				mediaFrame.setTitle("My Video");

			}else{
				mediaFrame=guiManager.getMediaPanel().getOthersNewVideoFrame();
				mediaFrame.setTitle(media+" from "+userInfoManager.getUserName(src));
			}
		}else{ //media=="audio"
			if(myAddress.equals(src)){
				mediaFrame=guiManager.getMediaPanel().getMyNewAudioFrame();
				mediaFrame.setTitle("My Audio");

			}else{
				mediaFrame=guiManager.getMediaPanel().getOthersNewAudioFrame();
				mediaFrame.setTitle(media+" from "+userInfoManager.getUserName(src));
			}
			
		}
		
		contentPane=mediaFrame.getContentPane();
		contentPane.setLayout( new BorderLayout() );
		framePanel = new JPanel();
		framePanel.setLayout( null );
		contentPane.add(framePanel, "Center");
		
		insets = mediaFrame.getInsets();
		contentPane.setSize(insets.left + insets.right + 320,
												insets.top + insets.bottom + 60);
		
		// Setup AWT listeners
		guiManager.getMainFrame().addWindowListener( new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
			killThePlayer();

			while (MediaPlayer.this.player != null) {
			try {
			Thread.currentThread().sleep(100);
			} catch (InterruptedException ie) {
			}
			}
			
			synchronized (MediaPlayer.this) {
			mediaFrame.dispose();
			}
			
			windowCount--;
			if (windowCount == 0)
			System.exit(0);
			}
			});

		framePanel.addComponentListener( new ComponentAdapter() {
			public void componentResized(ComponentEvent ce) {
			panelResized = true;
			doResize();
			}
			});

		mediaFrame.addComponentListener( new ComponentAdapter() {
			public void componentResized(ComponentEvent ce) {
			insets = mediaFrame.getInsets();
			Dimension dim = mediaFrame.getSize();
			framePanel.setSize(dim.width - insets.left - insets.right,
			dim.height - insets.top - insets.bottom);
			}
			});

		// Realize the player
		if (player != null) {
			player.addControllerListener( this );
			player.realize();
		}
	}

	/**
	 * Sleeps for specified number of milliseconds.
	 */
	private void sleep(long time) {
		try {
			Thread.currentThread().sleep(time);
		} catch (Exception e) {
		}
	}

	/**
	* Creates the menu bar.
	*/
	/*	private MenuBar createMenuBar() {
	ActionListener al = new ActionListener() {
	public void actionPerformed(ActionEvent ae) {
	String command = ae.getActionCommand();
	if (command.equals("Open File...")) {
	if (fd == null) {
	fd = new FileDialog(MediaPlayer.this, "Open File",
	FileDialog.LOAD);
	}
	fd.setDirectory(fileDirectory);
	fd.show();
	if (fd.getFile() != null) {
	fileDirectory = fd.getDirectory();
	String filename = fileDirectory + fd.getFile();
	openFile("file:" + filename);
	}
	} else if (command.equals("Open URL...")) {
	openURL();
	} else if (command.equals("Close Player")) {
	killThePlayer();
	} else if (command.equals("Exit")) {
	killThePlayer();
	synchronized (MediaPlayer.this) {
	dispose();
	}
	windowCount--;
	if (windowCount == 0)
	System.exit(0);
	}
	}
	};

	MenuItem item;
	MenuBar mb = new MenuBar();
	
	// File Menu
	Menu mnFile = new Menu("File");
	mnFile.add(item = new MenuItem("Open File..."));
	item.addActionListener(al);
	mnFile.add(item = new MenuItem("Open URL..."));
	item.addActionListener(al);
	mnFile.add(item = new MenuItem("New Player"));
	item.addActionListener( new ActionListener() {
	public void actionPerformed(ActionEvent ae) {
	MediaPlayer jpnew = new MediaPlayer(null, null);
	jpnew.fileDirectory = fileDirectory;
	}
	} );
	mnFile.add(item = new MenuItem("Close Player"));
	item.addActionListener(al);
	mnFile.add(item = new MenuItem("Exit"));
	item.addActionListener(al);

	// Options Menu	
	Menu mnOptions = new Menu("Options");
	cbAutoLoop = new CheckboxMenuItem("Auto replay");
	cbAutoLoop.setState(true);
	mnOptions.add(cbAutoLoop);
	
	this.menu = mnFile;
	mb.add(mnFile);
	mb.add(mnOptions);
	return mb;
	}
	*/
	public void addNotify() {
		mediaFrame.addNotify();
		windowCreated = true;
		insets = mediaFrame.getInsets();
		mediaFrame.validate();
	}

	/**
	 * Resize the visual and control components in the frame panel
	 */
	public void doResize() {
		Dimension d = framePanel.getSize();
		int videoHeight = d.height;
		if (controlComp != null) {
			videoHeight -= controlComp.getPreferredSize().height;
			if (visualComp != null)
				if (videoHeight < 2)
					videoHeight = 2;
			if (d.width < 80)
				d.width = 80;
			controlComp.setBounds(0, videoHeight,
														d.width, controlComp.getPreferredSize().height);
			controlComp.invalidate();
		}

		if (visualComp != null) {
			visualComp.setBounds(0, 0, d.width, videoHeight);
		}
		framePanel.validate();
	}

	/**
	* Bring up the open URL dialog
	*/
	/*public void openURL() {
	if (urlDialog == null) {
	urlDialog = new OpenURLDialog(this);
	} 
	urlDialog.show();
	}
	*/
	/**
	 * Close the player
	 */
	public synchronized void killThePlayer() {
		if (player != null) {
			player.close();
			progressBar = null;
		}
	}

	/**
	 * Handle Controller/Player events for the player that's currently active.
	 */
	public synchronized void controllerUpdate(ControllerEvent ce) {
		// RealizeCompleteEvent occurs after a realize() call. 
		if (ce instanceof RealizeCompleteEvent) {
			System.out.println("ControllerEvent=RealizeCompleteEvent");
			
			int width = 320;
			int height = 0;
			insets = mediaFrame.getInsets();

			if (progressBar != null)
				framePanel.remove(progressBar);

			if (( visualComp = player.getVisualComponent()) != null) {
				width = visualComp.getPreferredSize().width;
				height = visualComp.getPreferredSize().height;
				width = (int) (width * defaultScale);
				height = (int) (height * defaultScale);
				framePanel.add(visualComp);
				visualComp.setBounds(0, 0, width, height);
				addPopupMenu(visualComp);
				newVideo = true;
			}
			
			if ((controlComp = player.getControlPanelComponent()) != null) {
				int prefHeight = controlComp.getPreferredSize().height;
				framePanel.add(controlComp);
				controlComp.setBounds(0, height, width, prefHeight);
				height += prefHeight;
				newVideo = true;
			}
			
			// Set the title of the frame to the name of the media file.
			/*if (filename != null) {
			if (filename.indexOf("file:") == 0) {
			filename = filename.substring(5);
			}
			setTitle(filename);
			}
			*/
			
			// Ask the player to prefetch data and prepare to start.
			player.prefetch();
		}
		// PrefetchCompleteEvent is generated when the player has finished prefetching
		// enough data to fill its internal buffers and is ready to start playing.
		else if (ce instanceof PrefetchCompleteEvent) {
			System.out.println("ControllerEvent=PrefetchCompleteEvent");
			if (newVideo) {
				if (visualComp != null) {
					Dimension vSize = visualComp.getPreferredSize();
					vSize.width = (int) (vSize.width * defaultScale);
					vSize.height = (int) (vSize.height * defaultScale);
					if (controlComp != null)
						vSize.height +=
													 controlComp.getPreferredSize().height;
					panelResized = false;
					mediaFrame.setSize(vSize.width + insets.left + insets.right,
														 vSize.height + insets.top + insets.bottom);
					int waited = 0;
					while (panelResized == false && waited < 2000) {
						try {
							waited += 50;
							Thread.currentThread().sleep(50);
							Thread.currentThread().yield();
						} catch (InterruptedException ie) {}
					}
				} else {
					int height = 1;
					if (controlComp != null)
						height = controlComp.getPreferredSize().height;
					mediaFrame.setSize(320+insets.left + insets.right,
														 height + insets.top + insets.bottom);
				}
				newVideo = false;
			}

			if (player.getTargetState() != Controller.Started)
				player.start();
		}
		// EndOfMediaEvent occurs when the media file has played till the end.
		// The player is now in the stopped state.
		else if (ce instanceof EndOfMediaEvent) {
			System.out.println("ControllerEvent=EndOfMediaEvent");
			if (cbAutoLoop.getState()) {
				player.setMediaTime(new Time(0));
				player.prefetch();
			}
		}
		// If at any point the Player encountered an error - possibly in the data stream
		// and it could not recover from the error, it generates a ControllerErrorEvent
		else if (ce instanceof ControllerErrorEvent) {
			
			System.err.println("ControllerErrorEvent: " + ce);
			//killThePlayer();
			progressBar = null;
			if (visualComp != null)
				visualComp.remove(zoomMenu);
			framePanel.removeAll();
			visualComp = null;
			controlComp = null;
			mediaFrame.setSize(320, 60);
			player.removeControllerListener( this );
			player.close();
			player = null;
			progressBar = null;
		} 
		// Occurs when a player is closed.
		else if (ce instanceof ControllerClosedEvent) {
			System.out.println("ControllerEvent=ControllerClosedEvent");
			if (visualComp != null) {
				visualComp.remove(zoomMenu);
				visualComp = null;
			}
			if (controlComp != null) {
				controlComp = null;
			}
			player = null;
			framePanel.removeAll();
			
			System.gc();
			System.runFinalization();
			mediaFrame.setSize(320, 60);
			progressBar = null;

			if (newPlayer != null) {
				player = newPlayer;
				newPlayer = null;
				player.addControllerListener(this);
				player.realize();
				mediaFrame.validate();
			}
		}
		// DurationUpdateEvent occurs when the player's duration changes or is
		// updated for the first time
		else if (ce instanceof DurationUpdateEvent) {
			System.out.println("ControllerEvent=DurationUpdateEvent");
			Time t = ((DurationUpdateEvent)ce).getDuration();
		}
		// Caching control.
		else if (ce instanceof CachingControlEvent) {
			System.out.println("ControllerEvent=CachingControlEvent");
			CachingControl cc = ((CachingControlEvent)ce).getCachingControl();
			if (cc != null && progressBar == null) {
				progressBar = cc.getControlComponent();
				if (progressBar == null)
					progressBar = cc.getProgressBarComponent();
				if (progressBar != null) {
					framePanel.add(progressBar);
					Dimension prefSize = progressBar.getPreferredSize();
					progressBar.setBounds(0, 0, prefSize.width, prefSize.height);
					insets = mediaFrame.getInsets();
					framePanel.setSize(prefSize.width, prefSize.height);
					mediaFrame.setSize(insets.left + insets.right + prefSize.width,
														 insets.top + insets.bottom + prefSize.height);
				}
			}
		}
		else if (ce instanceof StartEvent) {
			System.out.println("ControllerEvent=StartEvent");
		}
		else if (ce instanceof MediaTimeSetEvent) {
			System.out.println("ControllerEvent=MediaTimeSetEvent");
		}
		else if (ce instanceof TransitionEvent) {
			System.out.println("ControllerEvent=TransitionEvent");
			System.out.println("TransitionEvent is "+ce);
		}
		else if (ce instanceof RateChangeEvent) {
			System.out.println("ControllerEvent=RateChangeEvent");
		}
		else if (ce instanceof StopTimeChangeEvent) {
			System.out.println("ControllerEvent=StopTimeChangeEvent");
		}
		else {
			// Catch implementation specific events here...

			// UnsupportedFormatEvent is not a part of the JMF 1.0 spec.
			// It is generates when the media contains something that is not
			// supported by the underlying framework.  For example, a QuickTime
			// movie with a VR track, an unsupported codec, etc.
			try {
				Class ufEvent = Class.forName("com.sun.media.UnsupportedFormatEvent");
				if (ufEvent.isInstance(ce)) {
					System.err.println("MediaPlayer: UnsupportedFormatEvent ");
					System.err.println("   Reason: " +
														 ((MediaEvent)ce).toString());
				}
			} catch (ClassNotFoundException e) {
			}

			// SizeChangeEvent is not a part of the JMF 1.0 spec. It is
			// generated when the size of the video changes or right at the
			// beginning of a video clip, to inform listeners about the
			// dimensions of the video
			try {
				Class scEvent = Class.forName("com.sun.media.SizeChangeEvent");

				if (scEvent.isInstance(ce)) {
					// The video size has changed, resize the panel
					if (framePanel != null && visualComp != null) {
						Dimension nooSize= visualComp.getPreferredSize();
						int nooWidth = (int) (nooSize.width * defaultScale);
						int nooHeight = (int) (nooSize.height * defaultScale);
						// Add the height of the default control component
						if (controlComp != null)
							nooHeight += controlComp.getPreferredSize().height;
						if (  framePanel.getSize().width != nooWidth ||
									framePanel.getSize().height != nooHeight  ) {
							mediaFrame.setSize(nooWidth + insets.left + insets.right,
																 nooHeight + insets.top + insets.bottom);
						} else
							doResize();
					}
				}
			} catch (ClassNotFoundException e) {
			}
		}
	}

	public void zoomTo(float z) {
		insets = mediaFrame.getInsets();
		if (visualComp != null) {
			Dimension d = visualComp.getPreferredSize();
			d.width = (int) (d.width * z);
			d.height = (int) (d.height * z);
			if (controlComp != null)
				d.height += controlComp.getPreferredSize().height;
			
			mediaFrame.setSize(d.width + insets.left + insets.right,
												 d.height + insets.top + insets.bottom);
		}
	}

	private void addPopupMenu(Component visual) {
		MenuItem mi;
		ActionListener zoomSelect;
		
		zoomMenu = new PopupMenu("Zoom");

		zoomSelect = new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
			String action = ae.getActionCommand();
			if (action.indexOf("1:2") >= 0)
			zoomTo(0.5f);
			else if (action.indexOf("1:1") >= 0)
			zoomTo(1.0f);
			else if (action.indexOf("2:1") >= 0)
			zoomTo(2.0f);
			else if (action.indexOf("4:1") >= 0)
			zoomTo(4.0f);
			}
			};
		visual.add(zoomMenu);
		mi = new MenuItem("Scale 1:2");
		zoomMenu.add(mi);
		mi.addActionListener(zoomSelect);
		mi = new MenuItem("Scale 1:1");
		zoomMenu.add(mi);
		mi.addActionListener(zoomSelect);
		mi = new MenuItem("Scale 2:1");
		zoomMenu.add(mi);
		mi.addActionListener(zoomSelect);
		mi = new MenuItem("Scale 4:1");
		zoomMenu.add(mi);
		mi.addActionListener(zoomSelect);
		
		visual.addMouseListener( new MouseAdapter() {
			public void mousePressed(MouseEvent me) {
			if (me.isPopupTrigger())
			zoomMenu.show(visualComp, me.getX(), me.getY());
			}

			public void mouseReleased(MouseEvent me) {
			if (me.isPopupTrigger())
			zoomMenu.show(visualComp, me.getX(), me.getY());
			}

			public void mouseClicked(MouseEvent me) {
			if (me.isPopupTrigger())
			zoomMenu.show(visualComp, me.getX(), me.getY());
			}
			} );
	}

	/*************************************************************************
	* Entry point for application
	*************************************************************************/
	/*
	public static void main(String [] args) {	
	PipedInputStream pipedInputStream=new PipedInputStream();
	System.out.println("Before MediaSource Constructor");
	MediaSource mds=new MediaSource(pipedInputStream);
	System.out.println("Before Manager.createPlayer()");
	try {
	
	try {
	player = Manager.createPlayer(mds);
	System.out.println("After Manager.createPlayer");
	} catch (NoPlayerException e) {
	Fatal("Error: Could not create player for " );
	}
	} catch (MalformedURLException e) {
	Fatal("Error: Invalid media file URL!");
	} catch (IOException e) {
	Fatal("Error: IO exception creating player for ");
	} catch (ThreadDeath td) {
	throw td;
	} catch (Throwable t) {
	System.out.println("player is "+player);
	System.out.println("Media Source is"+mds);
	Fatal("Error: " + t);
	}
	
	if (player != null)
	new MediaPlayer(player, null);
	

	if (MediaPlayer.windowCount == 0)
	new MediaPlayer(null, null);
	}

	static void Fatal(String s) {
	MessageBox mb = new MessageBox("JMF Error", s);
	}
	}
	
	class MessageBox extends Frame {
	
	public MessageBox(String title, String message) {
	super(title);
	setLayout( new BorderLayout() );
	
	// Panel at the bottom with a flow layout to put an OK button
	Panel bottom = new Panel();
	bottom.setLayout( new FlowLayout() );
	Button ok = new Button("OK");
	ok.addActionListener( new ActionListener() {
	public void actionPerformed(ActionEvent ae) {
	dispose();
	}
	} );
	bottom.add(ok);
	
	// Add a message label.
	add("Center", new Label(message, Label.CENTER));
	// Add the panel with the button to the south
	add("South", bottom);
	// Frame requires explicit setVisible(true)
	setVisible(true);
	}
	
	public void addNotify() {
	super.addNotify();
	pack();
	}
	*/
}

    
