package JavaGroups.VideoConference.Media.Playback;

import java.util.Enumeration;
import java.util.Vector;
import JavaGroups.Message;
import java.io.PipedOutputStream;

public class MediaBuffer{

	PipedOutputStream pipedOutputStream;
	byte[] buffer=null;
	int length=0;
	int seqNum=0;
	boolean endOfMedia=false;
	
	public MediaBuffer(PipedOutputStream pipedOutputStream,byte[] buffer,int length,int seqNum){
		this.buffer=buffer;
		this.length=length;
		this.seqNum=seqNum;
		this.pipedOutputStream=pipedOutputStream;
		
	}
	
	synchronized void start(){
		
		try{
			System.out.println("writing packet "+seqNum);
			pipedOutputStream.write(buffer,0,length);
			System.out.println("done writing packet "+seqNum);	
		}catch (Exception e){e.printStackTrace();}
		
		while(!endOfMedia){	
			try
			{
				wait();
				System.out.println("writing packet "+seqNum);
				pipedOutputStream.write(buffer,0,length);
				System.out.println("done writing packet "+seqNum);	
				
			}catch(Exception e){
				System.out.println("End of file reach!");
				e.printStackTrace();				
			}			
		}		
	}
	
	public synchronized void wakeThread(byte[] buffer,int length,int seqNum){
		this.buffer=buffer;
		this.length=length;
		this.seqNum=seqNum;
		notify();
	}

	public synchronized void wakeThreadLastTime(byte[] buffer,int length,int seqNum){
		this.buffer=buffer;
		this.length=length;
		this.seqNum=seqNum;
		endOfMedia=true;
		notify();
		
	}
}
