package JavaGroups.VideoConference.Media.Capture;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * VideoFileReaderThread is used by VideoManager read local video file 
 * and broadcast it to the group.
 * Note that the PacketDelay and PacketSize is defined in MediaManager
 ******************************************************************************/

import java.io.*;
import JavaGroups.*;
import JavaGroups.VideoConference.DataManager.DataMessage.*;

public class VideoFileReaderThread implements Runnable
{
	
	int VideoPacketDelay;
	int VideoPacketSize;
	
	FileInputStream fileInputStream;
	PipedInputStream pipedInputStream;
	PipedOutputStream pipedOutputStream;
	Channel channel;
	Object selfAddress;
	Thread t;
	boolean debug;
	boolean stop;
	
	public VideoFileReaderThread(boolean debug,Object selfAddress,Channel channel, FileInputStream fileInputStream,PipedInputStream pipedInputStream,
	PipedOutputStream pipedOutputStream,int VideoPacketDelay, int VideoPacketSize){
		this.debug=debug;
		this.selfAddress=selfAddress;
		this.channel=channel;
		this.fileInputStream=fileInputStream;
		this.pipedInputStream=pipedInputStream;
		this.pipedOutputStream=pipedOutputStream;
		this.VideoPacketDelay=VideoPacketDelay;
		this.VideoPacketSize=VideoPacketSize;
		t=new Thread(this,"VideoFileReaderThread");
		t.start();
	}
	
	
	public void stopVideo(){
		stop=true;
	}
	
		public void run(){
		byte[] buff=new byte[VideoPacketSize];
		int len=0;
		int num=0;
		
		try{
			
			len=fileInputStream.read(buff);
			if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}
			StartVideoMsg startVideoMsg=new StartVideoMsg(null,selfAddress,buff,len,num++);
			channel.Send(startVideoMsg);
			if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}

		}catch (Exception e){e.printStackTrace();}
		while(!stop){
			try{
				Thread.sleep(VideoPacketDelay);
				len=fileInputStream.read(buff);
				if(len<VideoPacketSize){
					EndVideoMsg endVideoMsg=new EndVideoMsg(null,selfAddress,buff,len,num++);
					fileInputStream.close();
					channel.Send(endVideoMsg);
					return;
				}
				VideoMsg videoMsg=new VideoMsg(null,selfAddress,buff,len,num++);
				channel.Send(videoMsg);
				if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}

			}catch(Exception e1){
				if(debug){System.out.println("End of file. Stop reading file");}
				break;
			}
		}
		if(stop){
			try{
			if(debug){System.out.println("Video broadcast stopped by initiator");}
			EndVideoMsg endVideoMsg=new EndVideoMsg(null,selfAddress,buff,len,num++);
			fileInputStream.close();
			channel.Send(endVideoMsg);
			}catch(Exception e){e.printStackTrace();}
				
		}
	}
}
