package JavaGroups.VideoConference.Media.Capture;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * AudioFileReaderThread is used by AudioManager read local audio file 
 * and broadcast it to the group.
 * Note that the PacketDelay and PacketSize is defined in MediaManager
 ******************************************************************************/


import java.io.*;
import JavaGroups.*;
import JavaGroups.VideoConference.DataManager.DataMessage.*;

public class AudioFileReaderThread implements Runnable
{
	
	int AudioPacketDelay;
	int AudioPacketSize;
	
	FileInputStream fileInputStream;
	PipedInputStream pipedInputStream;
	PipedOutputStream pipedOutputStream;
	Channel channel;
	Object selfAddress;
	Thread t;
	boolean debug;
	boolean stop=false;
	
	public AudioFileReaderThread(boolean debug,Object selfAddress,Channel channel, FileInputStream fileInputStream,PipedInputStream pipedInputStream,
	PipedOutputStream pipedOutputStream,int AudioPacketDelay, int AudioPacketSize){
		this.debug=debug;
		this.selfAddress=selfAddress;
		this.channel=channel;
		this.fileInputStream=fileInputStream;
		this.pipedInputStream=pipedInputStream;
		this.pipedOutputStream=pipedOutputStream;
		this.AudioPacketDelay=AudioPacketDelay;
		this.AudioPacketSize=AudioPacketSize;
		t=new Thread(this,"AudioFileReaderThread");
		t.start();
	}
	
	public void stopAudio(){
		stop=true;
	}
		public void run(){
		byte[] buff=new byte[AudioPacketSize];
		int len=0;
		int num=0;
		
		try{
			
			len=fileInputStream.read(buff);
			if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}
			StartAudioMsg startAudioMsg=new StartAudioMsg(null,selfAddress,buff,len,num++);
			channel.Send(startAudioMsg);
			if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}

		}catch (Exception e){e.printStackTrace();}
		while(!stop){
			try{
				Thread.sleep(AudioPacketDelay);
				len=fileInputStream.read(buff);
				if(len<AudioPacketSize){
					EndAudioMsg endAudioMsg=new EndAudioMsg(null,selfAddress,buff,len,num++);
					fileInputStream.close();
					channel.Send(endAudioMsg);
					return;
				}
				AudioMsg audioMsg=new AudioMsg(null,selfAddress,buff,len,num++);
				channel.Send(audioMsg);
				if(debug){System.out.println("reading packet "+ num +" from file with lenght "+ len);}

			}catch(Exception e1){
				if(debug){System.out.println("End of file. Stop reading file");}
				break;
			}
		}
		if(stop){
			try{
				EndAudioMsg endAudioMsg=new EndAudioMsg(null,selfAddress,buff,len,num++);
				fileInputStream.close();
				channel.Send(endAudioMsg);
			}catch(Exception e){e.printStackTrace(); }
		}
	}
}


