package JavaGroups.VideoConference.GUI;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * MediaPanel is the GUI component that displays activities in the audio/video channel
 * It communicates through GUIManager with AudioManager and VideoManager for user events.
 * 
 ******************************************************************************/
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;

public class MediaPanel extends JPanel implements InternalFrameListener
{
	JLayeredPane mainVideoPanel;
	JLayeredPane mainAudioPanel;
	JInternalFrame myVideoFrame;
	JInternalFrame othersVideoFrame;
	JInternalFrame myAudioFrame;
	JInternalFrame othersAudioFrame;
	JLabel mediaPanelLabel;
	Dimension videoFrameDimension=new Dimension(200,200);
	Dimension audioFrameDimension=new Dimension(200,50);
	
	public MediaPanel(){
		GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
		c.weightx=1.0;
		c.weighty=1.0;
		c.gridx=0;
		c.gridy=0;
		
		setLayout(gridbag);
		c.gridwidth = GridBagConstraints.REMAINDER;
		mainVideoPanel=new JLayeredPane();
		mainVideoPanel.setLayout(new GridLayout(1,2));
		mainVideoPanel.setBorder(BorderFactory.createEmptyBorder(10,20,10,10));	
		mediaPanelLabel=new JLabel("JavaGroupsVC");
		gridbag.setConstraints(mediaPanelLabel, c);
	
			
		
		c.gridx=GridBagConstraints.RELATIVE;
		c.gridy=GridBagConstraints.RELATIVE;
		
	
		gridbag.setConstraints(mainVideoPanel, c);
	
		myVideoFrame=new JInternalFrame("My Video");
		myVideoFrame.addInternalFrameListener(this);
		myVideoFrame.setMinimumSize(videoFrameDimension);
		myVideoFrame.setPreferredSize(videoFrameDimension);
		myVideoFrame.setVisible(true);
		
		othersVideoFrame=new JInternalFrame("Incoming Video");	
		othersVideoFrame.addInternalFrameListener(this);
		othersVideoFrame.setMinimumSize(videoFrameDimension);
		othersVideoFrame.setPreferredSize(videoFrameDimension);
		othersVideoFrame.setVisible(true);
		mainVideoPanel.add(myVideoFrame);
		mainVideoPanel.add(othersVideoFrame);
		
		c.gridheight=GridBagConstraints.REMAINDER;
		
		mainAudioPanel=new JLayeredPane();
		mainAudioPanel.setLayout(new GridLayout(1,2));
		mainAudioPanel.setBorder(BorderFactory.createEmptyBorder(10,10,20,10));	
		gridbag.setConstraints(mainAudioPanel, c);
		myAudioFrame=new JInternalFrame("My Audio");
		myAudioFrame.addInternalFrameListener(this);
		myAudioFrame.setMinimumSize(audioFrameDimension);
		myAudioFrame.setPreferredSize(audioFrameDimension);
		myAudioFrame.setVisible(true);
		
		othersAudioFrame=new JInternalFrame("Incoming Audio");	
		othersAudioFrame.addInternalFrameListener(this);
		othersAudioFrame.setMinimumSize(audioFrameDimension);
		othersAudioFrame.setPreferredSize(audioFrameDimension);
		othersAudioFrame.setVisible(true);
		
		mainAudioPanel.add(myAudioFrame);
		mainAudioPanel.add(othersAudioFrame);
		
		add(mediaPanelLabel);	
		add(mainVideoPanel);
		add(mainAudioPanel);
		setVisible(true);	
	}
	
	public void restoreEmptyVideoFrames(){
		mainVideoPanel.removeAll();
		myVideoFrame=new JInternalFrame("My Video");
		myVideoFrame.addInternalFrameListener(this);
		myVideoFrame.setMinimumSize(videoFrameDimension);
		myVideoFrame.setPreferredSize(videoFrameDimension);
		myVideoFrame.setVisible(true);
		mainVideoPanel.add(myVideoFrame);
		othersVideoFrame=new JInternalFrame("Incoming Video");		
		othersVideoFrame.addInternalFrameListener(this);
		othersVideoFrame.setMinimumSize(videoFrameDimension);
		othersVideoFrame.setPreferredSize(videoFrameDimension);
		othersVideoFrame.setVisible(true);
		
	}
	public JInternalFrame getMyNewVideoFrame(){
		mainVideoPanel.remove(0);
		myVideoFrame=new JInternalFrame("My Video");
		myVideoFrame.addInternalFrameListener(this);
		myVideoFrame.setMinimumSize(videoFrameDimension);
		myVideoFrame.setPreferredSize(videoFrameDimension);
		mainVideoPanel.add(myVideoFrame,0);
		validate();
		return myVideoFrame;
	}
	public JInternalFrame getOthersNewVideoFrame(){
		mainVideoPanel.remove(1);
		othersVideoFrame=new JInternalFrame("Incoming Video");
		othersVideoFrame.addInternalFrameListener(this);
		mainVideoPanel.add(othersVideoFrame,1);
		othersVideoFrame.setMinimumSize(videoFrameDimension);
		othersVideoFrame.setPreferredSize(videoFrameDimension);
		validate();
		return othersVideoFrame;
	}
	public JInternalFrame getMyNewAudioFrame(){
		mainAudioPanel.remove(0);
		myAudioFrame=new JInternalFrame("My Audio");
		myAudioFrame.addInternalFrameListener(this);
    myAudioFrame.setMinimumSize(audioFrameDimension);
		myAudioFrame.setPreferredSize(audioFrameDimension);		
		mainAudioPanel.add(myAudioFrame,0);
		validate();
		return myAudioFrame;
	}
	public JInternalFrame getOthersNewAudioFrame(){
		mainAudioPanel.remove(1);
		othersAudioFrame=new JInternalFrame("Incoming Audio");
		othersAudioFrame.addInternalFrameListener(this);
		othersAudioFrame.setMinimumSize(audioFrameDimension);
		othersAudioFrame.setPreferredSize(audioFrameDimension);
		mainAudioPanel.add(othersAudioFrame,1);
		validate();
		return othersAudioFrame;
	}
	public JInternalFrame getOthersVideoFrame(){
		return othersVideoFrame;
	}
	public JInternalFrame getMyVideoFrame(){
		return myVideoFrame;
	}
	public JInternalFrame getOthersAudioFrame(){
		return othersAudioFrame;
	}
	public JInternalFrame getMyAudioFrame(){
		return myAudioFrame;
	}
	
	public void internalFrameClosing(InternalFrameEvent e) {
		System.out.println("Internal frame closing");    
	}
	public void internalFrameClosed(InternalFrameEvent e) {
		System.out.println("Internal frame closed");	 
	}
	public void internalFrameOpened(InternalFrameEvent e) {
		System.out.println("Internal frame opened");   
	}
	public void internalFrameIconified(InternalFrameEvent e) {
		System.out.println("Internal frame iconified");   
	}
	public void internalFrameDeiconified(InternalFrameEvent e) {
		System.out.println("Internal frame deiconified");    
	}
	public void internalFrameActivated(InternalFrameEvent e) {
		System.out.println("Internal frame activated");  
	}
	public void internalFrameDeactivated(InternalFrameEvent e) {
		System.out.println("Internal frame deactivated");   
	}
}
