package JavaGroups.VideoConference.GUI.Filters;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * VideoFilter is used by GUIManager to filter out unsupported video format
 * Note: Only *.mpg and *.mpeg format is supported in version 0.5
 ******************************************************************************/

import javax.swing.filechooser.FileFilter;
import java.io.File;

public class VideoFilter extends FileFilter
{
	
	
	public boolean accept(File f){
		if (f.isDirectory()) {	return true;    } 
		String s = f.getName();
		int i = s.lastIndexOf('.');   
		if (i > 0 &&  i < s.length() - 1) {
			
			String extension = s.substring(i+1).toLowerCase();
			if ( extension.equals("mpeg") || extension.equals("mpg") ) {
				return true;
			} else {
				return false;
			}
		}   
		return false;
	}
	
	public String getDescription(){
		return "MPEG movie clips";
		
	}
}
	

