package JavaGroups.VideoConference.GUI.Filters;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * AudioFilter is used by GUIManager to filter out unsupported audio format
 * Note: Only *.au format is supported in version 0.5
 ******************************************************************************/

import javax.swing.filechooser.FileFilter;
import java.io.File;

public class AudioFilter extends FileFilter
{	
	public boolean accept(File f){
		if (f.isDirectory()) {	return true;    } 
		String s = f.getName();
		int i = s.lastIndexOf('.');   
		if (i > 0 &&  i < s.length() - 1) {
			
			String extension = s.substring(i+1).toLowerCase();
			if ( extension.equals("au") ) {
				return true;
			} else {
				return false;
			}
		}   
		return false;
	}
	
	public String getDescription(){
		return "AU audio clips";
		
	}
}
	