package JavaGroups.VideoConference.DataManager;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * VideoManager is the channel manager for the video channel 
 * It communicates through GUIManager for user events.
 * 
 ******************************************************************************/
import JavaGroups.*;
import JavaGroups.VideoConference.Manager;
import JavaGroups.VideoConference.ControlManager.*;
import JavaGroups.VideoConference.DataManager.DataMessage.*;
import JavaGroups.VideoConference.Media.Playback.*;
import JavaGroups.VideoConference.Media.Capture.*;
import JavaGroups.VideoConference.GUI.GUIManager;


import java.io.*;
import javax.media.*;

public class VideoManager extends MediaManager
{
	VideoFileReaderThread videoFileReaderThread;
	
	public VideoManager(boolean debug,UserInfoManager userInfoManager,ChannelFactory channeFactory,GUIManager guiManager){		
		super(debug, userInfoManager, channeFactory, guiManager);		
	}
	
	public String nameChannel(String groupName){
		channelName=new String(groupName+"@video");
		return channelName;
	}
		public boolean connectToGroup(String groupName,String prop){
		this.groupName=groupName;
		channelName=nameChannel(groupName);
		try{
			channel=channelFactory.CreateChannel(prop);
			channel.Connect(channelName);
		}catch (Exception e)
		{
			e.printStackTrace();
			return false;
		}
		
		adapter=new PullPushAdapter(channel,this,this);
		selfAddress=userInfoManager.getMyUserInfo().getAddress();
		channelAddress=channel.GetLocalAddress();
		userInfoManager.getMyUserInfo().setVideoAddress(channelAddress);
		guiManager.getMembershipManager().bcastVideoChannelAddress(channelAddress);
		if(debug)
		{
			System.out.println("Connected successfully to channel <"+channelName+"> of group <"+groupName+">");
		}				
		return true;
	}
	public void startCaptureMedia(){
		
	/*
		Not implemented in version 0.5
		Need JMF2.0 for the capture
		
	*/
		
	}

	public void stopBroadcastMedia(){
		videoFileReaderThread.stopVideo();
	
	}
	
	public void startBroadcastMedia(){
		videoFileReaderThread=new VideoFileReaderThread(debug,selfAddress,channel,fileInputStream,pipedInputStream,
												 pipedOutputStream,VideoPacketDelay,VideoPacketSize);
	}
	
	private void stopCaptureMedia(){
		/*
		Not implemented in version 0.5
		Need JMF2.0 for the capture
		
	*/
	}
	
	
	public void Receive(Message msg){
		
		//If you join the group in the middle of a _broadCast_
		//you won't be able to see anything
		
		if((!receivingData)&&(!(msg instanceof StartVideoMsg))){return;}
		if(ignoreCurrentSession && msg instanceof VideoMsg){return;}
		try{
			if(msg instanceof VideoMsg){
				if(debug){System.out.println("Received VideoMsg "+ ((VideoMsg)msg).seqNum +" from "+ msg.GetSrc());}
				mediaBuffer.wakeThread(msg.GetBuffer(),((VideoMsg)msg).length,((VideoMsg)msg).seqNum); 
			}else if(msg instanceof StartVideoMsg){
				setupPlaybackChannel("video.mpeg",msg.GetSrc(),msg.GetBuffer(),((StartVideoMsg)msg).length,((StartVideoMsg)msg).seqNum);
				mediaBuffer.wakeThread(msg.GetBuffer(),((StartVideoMsg)msg).length,((StartVideoMsg)msg).seqNum); 		
				receivingData=true;
				guiManager.menuItemStopVideoFile.setEnabled(true);
				if(debug){System.out.println("Received StartVideoMsg from "+msg.GetSrc() );}
			}else if(msg instanceof EndVideoMsg){
				if(debug){System.out.println("Received EndVideoMsg");}
				mediaBuffer.wakeThreadLastTime(msg.GetBuffer(),((EndVideoMsg)msg).length,((EndVideoMsg)msg).seqNum); 		
				receivingData=false;
				//if you are coordinator, inform all members, now Bcast channel is idle
				if(guiManager.getMembershipManager().isCoordinator){
					guiManager.getMembershipManager().clearVideoBcastChannel();
					guiManager.getMembershipManager().bcastEndVideoBcastMsg();
				}
				if(msg.GetSrc().equals(selfAddress)){
					guiManager.getMediaPanel().getMyNewVideoFrame();
				}else{
					guiManager.getMediaPanel().getOthersNewVideoFrame();
				}
				player.stop();
				player.deallocate();
				player.close();
				ignoreCurrentSession=false;

			}
		}catch (Exception e){e.printStackTrace();}
	}	
	
	
		public void Suspect(Object address){}
		public void ViewAccepted(View newView){	}

}
