package JavaGroups.VideoConference.DataManager;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * MediaManager is the super class for all data channel Manager
 * It defines the common channel operaions such as connect to group, setup 
 * playback channel and so on
 * Extended by TextManager, AudioManager and VideoManager
 * 
 ******************************************************************************/
import JavaGroups.*;
import JavaGroups.VideoConference.Manager;
import JavaGroups.VideoConference.ControlManager.*;
import JavaGroups.VideoConference.DataManager.DataMessage.*;
import JavaGroups.VideoConference.GUI.GUIManager;
import JavaGroups.VideoConference.Media.Playback.*;

import java.io.*;
import javax.media.*;

public class MediaManager extends Manager
{
	boolean debug;
	Object channelAddress=null;
	FileInputStream fileInputStream;
	PipedInputStream pipedInputStream;
	PipedOutputStream pipedOutputStream;
	MediaBuffer mediaBuffer;
	Player player;
	boolean receivingData=false;
	boolean videoConferencing=false;
	boolean ignoreCurrentSession=false;
	final int AudioPacketSize=4096;
	final int VideoPacketSize=8192;
	final int AudioPacketDelay=500;
	final int VideoPacketDelay=500;

	public MediaManager(boolean debug, UserInfoManager userInfoManager,ChannelFactory channelFactory,GUIManager guiManager){
		
		this.debug=debug;
		this.userInfoManager=userInfoManager;
		this.userInfoManager=userInfoManager;
		this.channelFactory=channelFactory;
		this.guiManager=guiManager;
		
	}
	
	public boolean connectToGroup(String groupName,String prop){
		this.groupName=groupName;
		channelName=nameChannel(groupName);
		try{
			channel=channelFactory.CreateChannel(prop);
			channel.Connect(channelName);
		}catch (Exception e)
		{
			e.printStackTrace();
			return false;
		}
		
		adapter=new PullPushAdapter(channel,this,this);
		selfAddress=userInfoManager.getMyUserInfo().getAddress();
		if(channelName.endsWith("video")){
			userInfoManager.getMyUserInfo().setVideoAddress(channel.GetLocalAddress());
			if(debug)System.out.println("<<<<<<<<It is a video Channel>>>>>>>>>>>");
		}else if(channelName.endsWith("audio")){
			userInfoManager.getMyUserInfo().setAudioAddress(channel.GetLocalAddress());
			if(debug)System.out.println("<<<<<<<<<<<It is a audio Channel>>>>>>>>>>");

		}
		
		if(debug)
		{
			System.out.println("Connected successfully to channel <"+channelName+"> of group <"+groupName+">");
		}				
		return true;
	}
	
	public boolean disconnectFromGroup(){
		channel.Disconnect();
		return true;
	}

	public String nameChannel(String groupName){
		return groupName+"genericChannel";
	}
	
	public void setupCaptureChannel(String fileName){
	
		/*
		Not implemented in version 0.5
		Need JMF2.0 for the capture
		
	*/
	}	
	public void ignoreCurrentSession(){
		ignoreCurrentSession=true;	
	}
	public void setupBroadcastChannel(String fileName){
		try{
			fileInputStream=new FileInputStream(fileName);
		}catch(Exception e){e.printStackTrace();}	
	}	

	public void setupPlaybackChannel(String mediaType,Object src, byte[] buffer,int length, int seqNum){
		try {
			
			pipedInputStream=new PipedInputStream();
			pipedOutputStream=new PipedOutputStream(pipedInputStream);
			System.out.println("Before mediasource in setupPlaybackChannel");
			mediaBuffer=new MediaBuffer(pipedOutputStream,buffer,length,seqNum);
		  MediaSource mds=new MediaSource(pipedInputStream);
			mds.setMediaType(mediaType);
			MediaFetchThread t=new MediaFetchThread(mediaBuffer);
			System.out.println("after mediasource in setupPlaybackChannel");				
				try {
					player = javax.media.Manager.createPlayer(mds);
					System.out.println("After Manager.createPlayer");
				} catch (NoPlayerException e) {
					System.out.println("Error: Could not create player for " );
				}
			} catch (Exception e1) {
					System.out.println("Error: " + e1);
			}
			  String media;
				if(channelName.endsWith("audio")){
						media="audio";
				}else if(channelName.endsWith("video")){
					media="video";
				}else{
					media=null;
				}
				new MediaPlayer(player,media,guiManager,userInfoManager,src);	
	
	}
	
	private void startPlaybackMedia(){}
	private void stopPlaybackMedia(){}
	public void startCaptureMedia(){}
	private void stopCaptureMedia(){}
	public void Receive(Message msg){}
	public void Block(){}
	public void Suspect(Object address){}
	public void ViewAccepted(View newView){}	
	
}
