package JavaGroups.VideoConference.DataManager;
/******************************************************************************
 * JavaGroupsVC version 0.5 beta 
 * 
 * AudioManager is the channel manager for the audio channel 
 * It communicates through GUIManager for user events.
 * 
 ******************************************************************************/
import JavaGroups.*;
import JavaGroups.VideoConference.Manager;
import JavaGroups.VideoConference.ControlManager.*;
import JavaGroups.VideoConference.Media.Capture.*;
import JavaGroups.VideoConference.DataManager.DataMessage.*;
import JavaGroups.VideoConference.Media.Playback.*;
import JavaGroups.VideoConference.GUI.GUIManager;


import java.io.*;
import javax.media.*;

public class AudioManager extends MediaManager
{
	
	AudioFileReaderThread audioFileReaderThread;
	public AudioManager(boolean debug,UserInfoManager userInfoManager,ChannelFactory channeFactory,GUIManager guiManager){		
		super(debug, userInfoManager, channeFactory, guiManager);		
	}
	
	public String nameChannel(String groupName){
		channelName=new String(groupName+"@audio");
		return channelName;
	}
	public boolean connectToGroup(String groupName,String prop){
		this.groupName=groupName;
		channelName=nameChannel(groupName);
		try{
			channel=channelFactory.CreateChannel(prop);
			channel.Connect(channelName);
		}catch (Exception e)
		{
			e.printStackTrace();
			return false;
		}
		
		adapter=new PullPushAdapter(channel,this,this);
		selfAddress=userInfoManager.getMyUserInfo().getAddress();
		channelAddress=channel.GetLocalAddress();
		userInfoManager.getMyUserInfo().setAudioAddress(channelAddress);
		guiManager.getMembershipManager().bcastAudioChannelAddress(channelAddress);
		if(debug)
		{
			System.out.println("Connected successfully to channel <"+channelName+"> of group <"+groupName+">");
		}				
		return true;
	}
	
	public void stopBroadcastMedia(){
		audioFileReaderThread.stopAudio();
	}
	
	public void startBroadcastMedia(){
		audioFileReaderThread=new AudioFileReaderThread(debug,selfAddress,channel,fileInputStream,pipedInputStream,
												 pipedOutputStream,AudioPacketDelay,AudioPacketSize);

	}
	public void startCaptureMedia(){
		/*
		
		Not implemented in version 0.5
		Need JMF2.0 for the capture
		
	*/
	}

	private void stopCaptureMedia(){
		/*
		
		Not implemented in version 0.5
		Need JMF2.0 for the capture
		
	 */
	}
	public void Receive(Message msg){
		
		//If you join the group in the middle of a _broadCast_
		//you won't be able to see anything
		if((!receivingData)&&(!(msg instanceof StartAudioMsg))){return;}
		if(ignoreCurrentSession && msg instanceof AudioMsg){return;}

		try{
			if(msg instanceof AudioMsg){
				if(debug){System.out.println("Received AudioMsg "+ ((AudioMsg)msg).seqNum);}
				mediaBuffer.wakeThread(msg.GetBuffer(),((AudioMsg)msg).length,((AudioMsg)msg).seqNum); 
			}else if(msg instanceof StartAudioMsg){
				setupPlaybackChannel("audio.basic",msg.GetSrc(),msg.GetBuffer(),((StartAudioMsg)msg).length,((StartAudioMsg)msg).seqNum);
				mediaBuffer.wakeThread(msg.GetBuffer(),((StartAudioMsg)msg).length,((StartAudioMsg)msg).seqNum); 		
				receivingData=true;
				guiManager.menuItemStopAudioFile.setEnabled(true);
				if(debug){System.out.println("Received StartAudioMsg");}
			}else if(msg instanceof EndAudioMsg){
				if(debug){System.out.println("Received EndAudioMsg");}	
				mediaBuffer.wakeThreadLastTime(msg.GetBuffer(),((EndAudioMsg)msg).length,((EndAudioMsg)msg).seqNum); 		
				receivingData=false;
				//if you are coordinator, inform all members, now Bcast channel is idle
				if(guiManager.getMembershipManager().isCoordinator){
					guiManager.getMembershipManager().clearAudioBcastChannel();
					guiManager.getMembershipManager().bcastEndAudioBcastMsg();
				}
				if(msg.GetSrc().equals(selfAddress)){
					guiManager.getMediaPanel().getMyNewAudioFrame();
				}else{
					guiManager.getMediaPanel().getOthersNewAudioFrame();

				}
				player.stop();
				player.deallocate();
				player.close();
				ignoreCurrentSession=false;
			}
		}catch (Exception e){e.printStackTrace();}
	}	
		public void Suspect(Object address){}
		public void ViewAccepted(View newView){	}

}
