package JavaGroups;


/**
   Maintains a set of ReusableThreads. When a thread is to be returned, all existing threads
   are checked: when one is available, it will be returned. Otherwise, a new thread is created
   and returned, unless the pool limit is reached, in which case <code>null</code> is returned.
 */
public class ThreadPool {
    int             MAX_NUM=255;
    int             current_index=0;   /// next available thread
    ReusableThread  pool[]=null;
    

    public ThreadPool(int max_num) {
	MAX_NUM=max_num;
	pool=new ReusableThread[MAX_NUM];
	for(int i=0; i < pool.length; i++) {pool[i]=null;}
    }

    
    public synchronized ReusableThread GetThread() {
	ReusableThread retval=null, tmp;

	// check whether a previously created thread can be reused
	for(int i=0; i < current_index; i++) {
	    tmp=pool[i];
	    if(tmp.Available()) {
		tmp.SetAvailable(false);
		return tmp;
	    }
	}

	// else create a new thread and add it to the pool
	if(current_index >= MAX_NUM) {
	    System.err.println("ThreadPool.GetThread(): could not create new thread because " +
			       "pool's max size reached (" + MAX_NUM + ") !");
	    return null;
	}
	else {
	    retval=new ReusableThread();
	    retval.SetAvailable(false);
	    pool[current_index++]=retval;
	    return retval;
	}

    }

    public void Destroy() {DeletePool();}

    public void finalize() {DeletePool();}


    public String toString() {
	StringBuffer ret=new StringBuffer();

	ret.append("ThreadPool: capacity=" + pool.length + ", index=" + current_index + "\n");
	ret.append("Threads are:\n");
	for(int i=0; i < current_index; i++)
	    ret.append("[" + i + ": " + pool[i] + "]\n");
	return ret.toString();
    }


    void DeletePool() {
	ReusableThread t;

	for(int i=0; i < MAX_NUM; i++) {
	    t=(ReusableThread)pool[i];
	    if(t != null) {
		t.Stop();
		pool[i]=null;
	    }
	}
    }
    


    public static void main(String[] args) {

	class MyThread extends Thread {
	    int num=0;
	    public MyThread(int num) {this.num=num;}

	    public void run() {
		long sleep_time=(long)(Math.random() * 1000);
		//System.out.print("Thread #" + num + ": sleeping " + sleep_time + ":");
		Util.Sleep(sleep_time);
		//System.out.println(" -- done");
	    }
	}

	ThreadPool      pool=new ThreadPool(5);
	ReusableThread  t;
	MyThread        my=new MyThread(1);
	int             i=0;

	while(true) {
	    t=pool.GetThread();
	    my.num=i++;

	    if(t != null) {
		System.out.println("Assigning task");
		t.AssignTask(my);
		Util.Sleep(100);
	    }
	    else {
		System.out.println("Waiting a bit for threads to become available...");
		Util.Sleep(1000);
	    }

	}
    }

    
}
