package JavaGroups;

import java.io.*;

/**
   LIFO stack, with better performance than java.util.Stack (based on Vector).
 */
public class Stack extends List implements Externalizable {

    
    public Stack() {}


    public void Push(Object obj) {
	AddAtHead(obj);
    }

    public Object Pop() {
	return RemoveFromHead();
    }

    public Object Peek() {
	return PeekAtHead();
    }


    public boolean Empty() {
	return size <= 0;
    }


    public List Copy() {
	Stack retval=new Stack();

	synchronized(mutex) {
	    for(Element el=head; el != null; el=el.next)
		retval.Add(el.obj);
	}
	return retval;
    }



    public void writeExternal(ObjectOutput out) throws IOException {
	super.writeExternal(out);
    }



    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
	super.readExternal(in);
    }





    public static void main(String[] args) {
	Stack   st1=new Stack(), st2;
	byte[]  buf;


	try {
	    for(int i=0; i < 5; i++)
		st1.Push(new Integer(i));

	    
	    buf=Util.ObjectToByteBuffer(st1);
	    st1.Pop();
	    System.out.println(st1.Dump());

	    st2=(Stack)Util.ObjectFromByteBuffer(buf);
	    System.out.println(st2.Dump());


	    st1=(Stack)st2.Copy();
	    System.out.println(st1.Dump());
	    System.out.println(st2.Dump());
	}
	catch(Exception e) {
	    System.err.println(e);
	}

	

    }

}
