package JavaGroups;



/**
   Reusable thread class. Instead of creating a new thread per task, this instance can be reused
   to run different tasks in turn. This is done by looping and assigning the Runnable target objects
   whose <code>run</code> method is then called.
 */
public class ReusableThread extends Thread {
    Runnable  target=null;
    Object    start_mutex=new Object();
    boolean   available=true, started=false;
    


    public void Start() {
	if(!isAlive())
	    start();
    }


    public void Stop() {
	if(isAlive()) {
	    stop();
	    target=null;
	}
    }



    public void finalize() {Stop();}



    public void AssignTask(Runnable target) {
	available=false;
	Start();

	if(this.target == null) {
	    this.target=target;

	    synchronized(start_mutex) {
		start_mutex.notify();	    // signal self to start working on target.run()
	    }
	}
	else
	    System.err.println("ReusableThread.AssignTask(): already working on a thread !");
    }




    public void run() {
	while(true) {
	    synchronized(start_mutex) {
		while(target == null) {
		    try {
			start_mutex.wait();
		    }
		    catch(InterruptedException interrupted) {}
		}
	    }
	    target.run();
	    target=null;  // we're done
	    available=true;
	    synchronized(this) {
		notifyAll();
	    }
	}
    }

    public void    SetAvailable(boolean a)  {available=a;}
    public boolean Available()              {return available;}
    public boolean Done()                   {return target == null ? true : false;}


    public void WaitUntilDone() {
	synchronized(this) {
	    while(target != null) {
		try {
		    wait();
		}
		catch(InterruptedException interrupted) {}
	    }
	}
    }



    public static void main(String[] args) {
	
	class MyThread extends Thread {
	    int num=0;
	    public MyThread(int num) {this.num=num;}

	    public void run() {
		long sleep_time=(long)(Math.random() * 5000);
		System.out.print("Thread #" + num + ": sleeping " + sleep_time + ":");
		Util.Sleep(sleep_time);
		System.out.println(" -- done");
	    }
	}


	ReusableThread t=new ReusableThread();
	t.Start();
	MyThread m1=new MyThread(1);
	MyThread m2=new MyThread(2);
	MyThread m3=new MyThread(3);

	t.AssignTask(m1);
	t.WaitUntilDone();  // passive wait
	t.AssignTask(m2);
	t.WaitUntilDone();
	t.Stop();
    }


}




