package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

public abstract class GmsImpl {
    protected GMS          gms=null;


    public abstract void      Join(Address mbr);
    public abstract void      Leave(Address mbr);
    public abstract void      Suspect(Address mbr);
    public abstract void      Merge(Vector new_mbrs);

    public abstract boolean   HandleJoin(Address mbr);
    public abstract void      HandleLeave(Address mbr, boolean suspected);
    public abstract void      HandleViewChange(ViewId new_view, Vector mbrs);
    public abstract void      HandleMerge(Vector new_mbrs, Vector suspects, long other_ltime);
    public abstract void      HandleSuspect(Address mbr);

    public boolean            HandleUpEvent(Event evt) {return true;}
    public boolean            HandleDownEvent(Event evt) {return true;}



    protected void WrongMethod(String method_name) {
	System.err.println("GmsImpl: method " + method_name + 
			   "() should not be sent to an instance of " + getClass().getName());
    }

}
