package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;


class ExampleHeader implements Serializable {
    // your variables

    public ExampleHeader() {
    }

    public String toString() {
	return "[EXAMPLE: <variables> ]";
    }
}


/**
 * Example of a protocol layer. Contains no real functionality, can be used as a template.
 */

public class EXAMPLE extends Protocol {
    boolean  trace=false;
    Vector   members=new Vector();

    /** All protocol names have to be unique ! */
    public String  GetName() {return "EXAMPLE";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("EXAMPLE.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}




    public void Up(Event evt) {
	Message msg;

	switch(evt.GetType()) {

	case Event.START:
	    // Start work
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. extract the message and remove a header.
	    // Optionally pass up
	    break;
	}

	PassUp(evt);            // Pass up to the layer above us
    }





    public void Down(Event evt) {
	Message msg;

	switch(evt.GetType()) {
	case Event.STOP:
	    // Stop work
	    PassDown(evt);
	    break;

	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    synchronized(members) {
		members.removeAllElements();
		if(new_members != null && new_members.size() > 0)
		    for(int i=0; i < new_members.size(); i++)
			members.addElement(new_members.elementAt(i));
	    }
	    PassDown(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. add a header to the message
	    // Optionally pass down
	    break;
	}

	PassDown(evt);          // Pass on to the layer below us
    }



}
