package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**
   Discards up or down messages based on a percentage, e.g. setting property 'up' to 0.1 causes 10%
   of all up messages to be discarded. Setting 'down' or 'up' to 0 causes no loss, whereas 1 discards
   all messages (not very useful).
 */

public class DISCARD extends Protocol {
    boolean   trace=false;
    Vector    members=new Vector();
    double    up=0.0;    // probability of dropping up   msgs
    double    down=0.0;  // probability of dropping down msgs

    //int num_sent=25;  // don't discard the first 5 messages. Temporary, +++remove later !


    /** All protocol names have to be unique ! */
    public String  GetName() {return "DISCARD";}



    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}

	str=props.getProperty("up");
	if(str != null) {
	    up=new Double(str).doubleValue();
	    props.remove("up");
	}

	str=props.getProperty("down");
	if(str != null) {
	    down=new Double(str).doubleValue();
	    props.remove("down");
	}

	if(props.size() > 0) {
	    System.err.println("DISCARD.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }




    public void Up(Event evt) {
	Message msg;
	double  r;

	if(evt.GetType() == Event.MSG) {
	    msg=(Message)evt.GetArg();

	    if(up > 0) {
		//  		if(num_sent > 0) {
		//  		    num_sent--;
		//  		    PassUp(evt);
		//  		    return;
		//  		}
		r=Math.random();
		if(r < up) {
		    if(trace) System.out.println("DISCARD.Up(): dropping message");
		    return;
		}
	    }


	}

	PassUp(evt);
    }


    public void Down(Event evt) {
	Message msg;
	double  r;

	if(evt.GetType() == Event.MSG) {
	    msg=(Message)evt.GetArg();

	    
	    if(down > 0) {
		//  		if(num_sent > 0) {
		//  		    num_sent--;
		//  		    PassDown(evt);
		//  		    return;
		//  		}
		r=Math.random();
		if(r < down) {
		    if(trace) System.out.println("DISCARD.Down(): dropping message");
		    return;
		}
	    }


	}


	PassDown(evt);
    }



}
