package JavaGroups.JavaStack;

import java.util.*;
import java.io.*;
import java.net.*;



/**
   Network-dependent address (Internet). Generated by the bottommost layer of the protocol 
   stack (UDP).
 */
public class Address implements Externalizable { // Serializable {
    private InetAddress  ip_addr=null;
    private int          port=0;


    // Used only by Externalization
    public Address() {}

    public Address(String i, int p) {
	try {
	    ip_addr=InetAddress.getByName(i);
	}
	catch(Exception e) {
	}
	port=p;
    }

    public Address(InetAddress i, int p) {
	ip_addr=i; port=p;
    }


    public Address(int port) {
	try {
	    ip_addr=InetAddress.getLocalHost();
	    this.port=port;
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public InetAddress  GetIpAddress()               {return ip_addr;}
    public void         SetIpAddress(InetAddress i)  {ip_addr=i;}
    public int          GetPort()                    {return port;}
    public boolean      IsMulticastAddress() {
	return ip_addr != null ? ip_addr.isMulticastAddress() : false;
    }


    public void SetLocalHost() {
	try {
	    ip_addr=InetAddress.getLocalHost();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    /**
       Establishes an order between 2 addresses. Assumes other contains non-null Address.
       Excludes channel_name from comparison.
       @return 0 for equality, value less than 0 if smaller, greater than 0 if greater.
     */
    public int Compare(Address other) {
	int   h1, h2, rc;

	if(other == null) {
	    System.err.println("Address.Compare(): other address is null !");
	    return -1;
	}

	h1=ip_addr.hashCode();
	h2=other.ip_addr.hashCode();
	rc=h1 < h2? -1 : h1 > h2? 1 : 0;
	return rc != 0 ? rc : port < other.port ? -1 : (port > other.port ? 1 : 0);
    }
    
    

    public boolean equals(Object obj) {
	return Compare((Address)obj) == 0 ? true : false;
    }




    public int hashCode() {
 	int retval=ip_addr != null ? ip_addr.hashCode() + port : port;
 	return retval;
    }



    public String toString() {
	StringBuffer ret=new StringBuffer();
	String       h=ip_addr == null ? "<unknown host>" : ip_addr.getHostName();
	ret.append(h + ":" + port);
	return ret.toString();
    }




   public void writeExternal(ObjectOutput out) throws IOException {
       out.writeObject(ip_addr);
       out.writeInt(port);
   }



   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
       ip_addr=(InetAddress)in.readObject();
       port=in.readInt();
   }




    public static void main(String args[]) {
	
 	try {
 	    Address a1, a2;

	   
	    a1=new Address(InetAddress.getLocalHost(), 12341);
	    //a2=new Address(InetAddress.getLocalHost(), 12348);
 	    a2=new Address(InetAddress.getByName("128.84.248.240"), 12340);

 	    int rc=a1.Compare(a2);

 	    if(rc == 0)
 		System.out.println("equal");
 	    else if(rc > 0)
 		System.out.println("greater");
 	    else
 		System.out.println("smaller");


 	    FileOutputStream    fileout=new FileOutputStream("data.txt");
 	    ObjectOutputStream  out=new ObjectOutputStream(fileout);
	    
 	    out.writeObject(a1);
 	    out.writeObject(a2);
 	    out.close();


 	    FileInputStream     filein=new FileInputStream("data.txt");
 	    ObjectInputStream   in=new ObjectInputStream(filein);
 	    Address     i1=null, i2=null;

 	    i1=(Address)in.readObject();
 	    i2=(Address)in.readObject();

 	    System.out.println("i1: " + i1 + ", i2: " + i2);
	    
	    


	}
 	catch(Exception e) {
 	    System.err.println(e);
 	}

    }



//      public static void main(String args[]) {
//  	Address oid1=null, oid2=null, oid3=null;
//  	java.util.Hashtable h=new java.util.Hashtable();
	
//  	try {	   
//  	    oid1=new Address(5553);
//  	    oid1.SetLocalHost();
//  	    System.out.println(oid1);
//  	    oid2=new Address(java.net.InetAddress.getByName("janet"), 5555);
//  	    oid3=new Address(java.net.InetAddress.getByName("janet"), 5556);
//  	}
//  	catch(Exception e) {
//  	    System.err.println(e);
//  	}
	    
//  	h.put(oid1, "one");
//  	h.put(oid2, "two");
//  	h.put(oid3, "three");
//  	System.out.println(h);



//  	if(h.containsKey(oid2))
//  	    System.out.println("Hashtable " + h + " contains " + oid2);
//  	else
//  	    System.out.println("Hashtable " + h + " does NOT contain " + oid2);


//  	Vector v=new Vector();

//  	v.addElement(oid1);
//  	v.addElement(oid2);
//  	v.addElement(oid3);

//  	if(v.contains(oid2))
//  	    System.out.println("Vector " + v + " contains " + oid2);
//  	else
//  	    System.out.println("Vector " + v + " does NOT contain " + oid2);
	
//      }



}
