
import java.io.*;
import java.util.*;
import JavaGroups.*;



/**
   Example for MessageDispatcher (see also RpcDispatcherTest). Message is periodically broadcast to all
   members; Handle() method is invoked whenever a message is received.
 */
public class MessageDispatcherTest implements RequestHandler {
    Channel            channel;
    MessageDispatcher  disp;
    RspList            rsp_list;
    String             props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:"+
	                     "GMS(trace=true):VIEW_ENFORCER:QUEUE";



    public void Start() throws Exception {
	channel=new JChannel(props);
	disp=new MessageDispatcher(channel, null, null, this);
	channel.Connect("MessageDispatcherTestGroup");

	for(int i=0; i < 100; i++) {
	    Util.Sleep(2000);
	    rsp_list=disp.CastMessage(null, 
				      new Message(null, null, new String("Number #" + i).getBytes()),
				      GroupRequest.GET_ALL, 0);
	    System.out.println("Responses:\n" +rsp_list);
	}
	channel.Disconnect();
	channel.Close();
	disp.Stop();
    }



    public Object Handle(Message msg) {
	System.out.println("Handle(): " + msg);
	return new String("Success !");
    }



    public static void main(String[] args) {
	try {
	    new MessageDispatcherTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
