
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;


public class ColorComp extends Component implements Serializable, Cloneable {
    private Color         current_color;

    public ColorComp(Color initial_color) {
	current_color=initial_color;
	// setDoubleBuffered(true);
    }

    public int GetChecksum() {
	int retval=current_color.getRed() + current_color.getGreen() + current_color.getBlue();
	return retval;
    }

    public Color GetColor() {return current_color;}

    public void paint(Graphics g) {
	Rectangle bounds=getBounds();
	g.setColor(current_color);
	g.fillRect(1, 1, bounds.width-2, bounds.height-2);
    }

    public void SetColor(Color c) {
	Rectangle bounds=getBounds();
	current_color=c;
	//paintImmediately(new Rectangle(1, 1, bounds.width-2, bounds.height-2));
	repaint();
    }

    public Object clone() throws CloneNotSupportedException {
	return new ColorComp(current_color);
    }


    public String toString() {
	return "[" + current_color.getRed() + "|" + current_color.getGreen() + "|" +
	    current_color.getBlue() + "]";
    }


}
