

import java.io.*;
import java.util.*;
import JavaGroups.*;



/**
   Example of the STATE_TRANSFER protocol and API. The member periodically updates a shared state
   (consisting of an array of length 3). New members join the group and fetch the current state before
   they become operational. Existing members do not stop while new members fetch the group state.
 */
public class GetStateTest implements Runnable {
    Channel        channel;
    int[]          state;    // dice results, it *is* serializable !
    Thread         getter=null;
    boolean        rc=false;


    
    public void Start() throws Exception {
	channel=new JChannel("UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:"+ 
			     "STATE_TRANSFER:QUEUE");
	channel.SetOpt(Channel.GET_STATE_EVENTS, new Boolean(true));
	channel.Connect("TestChannel");

	System.out.println("Getting state");
	rc=channel.GetState(null, 3000);
	System.out.println("GetState(), rc=" + rc);
	if(rc == false) {
	    state=new int[3];
	    state[0]=1; state[1]=2; state[2]=3;
	}

	System.out.println("State is\n" + PrintState(state));
	Util.Sleep(2000);

	getter=new Thread(this, "Getter");
	getter.start();


	while(true) {
	    Message update=new Message(null, null, null);
	    int     index=(int)  ((Math.random() * 10) % 3);
	    
	    try {
		update.SetBuffer(Util.ObjectToByteBuffer(new Integer(index)));
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    System.out.println("Sending update for index " + index);
	    channel.Send(update);
	    Util.Sleep(2000);
	}
       
    }


    public void run() {
	Object ret;

	try {
	    while(true) {
		ret=channel.Receive(0);

		if(ret instanceof Message) {
		    Message m=(Message)ret;
		    Integer index;
		    int     in;

		    try {
			index=(Integer)Util.ObjectFromByteBuffer(m.GetBuffer());
			in=index.intValue();
			
			if(state != null) {
			    System.out.println("state[" + in + "]=" + (int)(state[in]+1));
			    state[index.intValue()]++;
			}
		    }
		    catch(ClassCastException cast_ex) {
			System.out.println("Contents of buffer was no Integer !");
		    }
		    catch(Exception e) {
			// System.err.println(e);
		    }
		    
		}
		else if(ret instanceof GetStateEvent) {
		    System.out.println("----> State transfer: " + ret);
		    channel.ReturnState(state);
		}
		else if(ret instanceof SetStateEvent) {
		    Object new_state=((SetStateEvent)ret).GetArg();
		    if(new_state != null)
			state=(int[])new_state;
		}
	    }
	}
	catch(Exception e) {
	}
    }
    

    String PrintState(int[] vec) {
	StringBuffer ret=new StringBuffer();
	if(vec != null)
	    for(int i=0; i < vec.length; i++)
		ret.append("state[" + i + "]: " + vec[i] + "\n");
	return ret.toString();
    }


    public static void main(String[] args) {
	try {
	    new GetStateTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

}
