package JavaGroups;

import java.io.*;
import java.util.*;
import JavaGroups.JavaStack.Address;

/**
   Keeps track of messages received from various senders. Acks each message received and checks whether
   it was already delivered. If yes, the message is discarded, otherwise it is delivered (passed up).
   The messages contain sequence numbers of old messages to be deleted, those are removed from the
   message table.

   @author Bela Ban June 17 1999
 */
public class AckMcastReceiverWindow {
    Hashtable msgs=new Hashtable();  // sender -- Vector (of seqnos)



    /**
       Records the sender/seqno pair in the message table
       @param sender The sender of the message
       @param seqno The sequence number associated with the message
       @return boolean If false, message is already present. Otherwise true.
     */
    public boolean Add(Object sender, long seqno) {
	Vector seqnos=(Vector)msgs.get(sender);
	Long   val=new Long(seqno);

	if(seqnos == null) {
	    seqnos=new Vector();
	    seqnos.addElement(val);
	    msgs.put(sender, seqnos);
	    return true;
	}

	if(seqnos.contains(val))
	    return false;

	seqnos.addElement(val);
	return true;	
    }




    public void Remove(Object sender, Vector seqnos) {
	Vector v=(Vector)msgs.get(sender);
	Long   seqno;

	if(v != null && seqnos != null) {
	    for(int i=0; i < seqnos.size(); i++) {
		seqno=(Long)seqnos.elementAt(i);
		v.removeElement(seqno);
	    }
	}
    }



    public long Size() {
	long ret=0;

	for(Enumeration e=msgs.elements(); e.hasMoreElements();) {
	    ret+=((Vector)e.nextElement()).size();
	}

	return ret;
    }


    public void Reset() {
	RemoveAll();
    }
    
    public void RemoveAll() {msgs.clear();}


    public void Suspect(Object sender) {
	msgs.remove(sender);
    }



    public String toString() {
	StringBuffer ret=new StringBuffer();
	Object       sender;
	
	for(Enumeration e=msgs.keys(); e.hasMoreElements();) {
	    sender=e.nextElement();
	    ret.append(sender + " --> " + msgs.get(sender) + "\n");
	}

	return ret.toString();
    }






    public static void main(String[] args) {
	AckMcastReceiverWindow win=new AckMcastReceiverWindow();
	Object sender1=new Address("janet", 1111);
	Object sender2=new Address("janet", 4444);
	Object sender3=new Address("janet", 6767);
	Object sender4=new Address("janet", 3333);

	win.Add(sender1, 1);
	win.Add(sender1, 2);

	win.Add(sender3, 2);
	win.Add(sender2, 2);
	win.Add(sender4, 2);
	win.Add(sender1, 3);
	win.Add(sender1, 2);


	System.out.println(win);

	win.Suspect(sender1);
	System.out.println(win);

	win.Add(sender1, 1);
	win.Add(sender1, 2);
	win.Add(sender1, 3);
	win.Add(sender1, 4);
	win.Add(sender1, 5);
	win.Add(sender1, 6);
	win.Add(sender1, 7);
	win.Add(sender1, 8);

	System.out.println(win);


	Vector seqnos=new Vector();

	seqnos.addElement(new Long(4));
	seqnos.addElement(new Long(6));
	seqnos.addElement(new Long(8));

	win.Remove(sender2, seqnos);
	System.out.println(win);

	win.Remove(sender1, seqnos);
	System.out.println(win);


    }

}
