#include <cstdio>

const int num_days_in_400_years = 400 * 365 + 97;
const int num_days_in_month[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

bool is_leap(int y) {
    if (y % 4) return false;
    if (y % 400 == 0) return true;
    return y % 100;
}

int main() {
    int m, d, y;
    int answer;

    int m2, d2, y2;

    int T;
    
    scanf("%d", &T);

    // while (T--) is a way to do something T times.
    while (T--) {
        scanf("%d %d %d", &m, &d, &y);

        // start at the release day
        answer = 0;
        m2 = 11;
        d2 = 18;
        y2 = 1999;

        // advances the date in m2/d2/y2 by one day
        auto advance = [&m2, &d2, &y2, &answer]() {
            d2++;
            int last_day_of_month = num_days_in_month[m2];
            if (m2 == 2 && is_leap(y2)) last_day_of_month++;

            if (d2 > last_day_of_month) {
                d2 = 1;
                m2++;
            }
            if (m2 > 12) {
                m2 = 1;
                y2++;
            }
            answer++;
        };

        // advance until the date, or until 1/1/2000, the beginning of a 400 year block
        bool found = false;
        while (y2 != 2000) {
            advance();
            if (m == m2 && d == d2 && y == y2) {
                printf("%d\n", answer);
                found = true;
                break;
            }
        }
        if (found) continue;

        int num_blocks_of_400_years = (y - 2000) / 400;
        answer += num_days_in_400_years * num_blocks_of_400_years;

        y2 += num_blocks_of_400_years * 400;

        // advance until we reach m/d/y
        while (m != m2 || d != d2 || y != y2) advance();

        printf("%d\n", answer);
    }
    return 0;
}
