#include <iostream>
#include <string>
#include <vector>
using namespace std;

/**************************************************************************************************************************
This was by far the hardest problem in the competition.

Note that because no suffix of TIMESQUIRE is also a prefix of it, the occurrences of
TIMESQUIRE in the final string (after modifying the input string) will be completely
disjoint. We will use this fact for the solution. The solution would have been considerably
harder if the lawyer were name IRE, so that the string he wants is IRESQUIRE, because then
we could have overlapping appearances, like IRESQUIRESQUIRE.

Let N be the length of the input, and let M be the length of TIMESQUIRE (i.e. M == 10).
We will solve the problem in two steps.

Step 1:
    For each position i from 0 to N - M + 1 compute what is the "cost" of writing TIMESQUIRE
    starting at position i (i.e., how many letters do we need to change).

    This can be trivially computed in O(NM). Let num_different[i] be the cost of writing
    TIMESQUIRE at position i

Step 2:
    We will solve this using Dynamic Programming[1] to solve the rest, given that we have already
    computed num_different.

    Let DP[i][j] be the maximum number of times we can write TIMESQUIRE using the first i characters
    of the input string, and changing at most j of those characters.

    Clearly DP[i][j] = 0 for all i < M (== 10), because it's impossible to write TIMESQUIRE with fewer
    than 10 characters. So from now on assume taht i >= M.

    DP[i][j] can be one of two options: Either there is a TIMESQUIRE written finishing at the i-th character
    or not.

    In case there isn't, then DP[i][j] = DP[i-1][j].

    In case there is, then DP[i][j] = 1 + DP[i-M][j - num_different[i-M]].

    So we take the minimum of the two.

    Read the case 2 above like this: "If there is a TIMESQUIRE finishing at the i-th character, then the best
    we can do is put it there (paying num_different[i-M]), and then do the best we can do with the first i-M
    characters and modifying at most j-num_different[i-M].

    This runs in O(NK)

So the total time to run both steps is O(NM + NK) which is small enough given the constraints.


[1] There are some good Dynamic Programming (DP) tutorials online at sites like TopCoder and Codeforces.
If you aren't familiar with the technique I recommend that you take a look.
**************************************************************************************************************************/
const string want = "TIMESQUIRE"; // The string we want. The code below works for any string that can't overlap with itself


int main() {
    // read the input
    int k;
    string input;
    cin >> k >> input;


    // STEP 1
    vector<int> num_different(input.size() - want.size() + 1);
    for (int i = 0; i < num_different.size(); i++) {
        int cnt = 0;
        for (int j = 0; j < want.size(); j++)
            if (want[j] != input[i+j])
                cnt++;
        num_different[i] = cnt;
    }

    // STEP 2
    // DP[i][j] = Best we can do ending at position i, changing j characters
    vector<vector<int>> DP(input.size() + 1, vector<int>(k+1, 0));

    for (int i = want.size(); i <= input.size(); i++)
    for (int j = 0; j <= k; j++) {
        DP[i][j] = DP[i-1][j]; // case 1

        // case 2 (note that we have to be sure that the index j - num_different[i - want.size()] >= 0
        if (num_different[i - want.size()] <= j) {
            DP[i][j] = max(DP[i][j], 1 + DP[i - want.size()][j - num_different[i - want.size()]]);
        }
    }

    // Finally the answer is DP[N][k]
    cout << DP.back().back() << endl;
    return 0;
}
