#include<cstdio>
#include<algorithm>

using namespace std;

/******************************************************************************
In this problem all we need to do is find the total number of forks, spoons, 
and chopsticks, and output the minimum we can serve with each one of them.

For chopsticks we should divide the total by 2 (and round down) since each
client receives two of them.
******************************************************************************/

int main() {
	int n, tot_fork = 0, tot_spoon = 0, tot_chop = 0;
    // scanf is a way to read from standard input. %d means "read one integer
    //   in decimal".
    //
    // In Java this would be done with a java.util.Scanner (int n = sc.nextInt())
    // In Python it could be done with n = int(input())
    // alternatively, in C++ it can also be cin >> n.
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		int fork, spoon, chop;
		scanf("%d %d %d", &fork, &spoon, &chop);
		tot_fork += fork;
		tot_spoon += spoon;
		tot_chop += chop;
	}
    // Note that C++ rounds towards zero when you divide two integers.
    // in Python 3 the same would be "tot_chop // 2"
	int ans = min({tot_fork, tot_spoon, tot_chop / 2});
	printf("%d\n", ans);
	return 0;
}
