import java.awt.*;

// A period of time at a certain title

public class TitleTime {
// Constants. All constants will always be in a contiguous range 1.. .
// Don't change ordering of these constants.
static public final int FIELD= 1;
static public final int LECTURER= 2;
static public final int SRLECTURER= 3;
static public final int INSTRUCTOR= 4;
static public final int ASSTPROF= 5;
static public final int ASSOCPROF= 6;
static public final int FULLPROF= 7;
static public final int EMERITUS= 8;

static public final int numTitles= 8; 	// Number of different titles

static public final int NOLEAVE= 1;		// Not on leave during the period
static public final int SABBATIC= 2;	// On sabbatic during the period
static public final int OTHERLEAVE= 3;	// On other leave during the period
 

Semester firstSemester;
Semester lastSemester;
int      title;     	// One of the constants LECTURER--FIELD
int      status;        // NOLEAVE, SABBATIC, or OTHERLEAVE

// Constructor: a time at title t, beginning in semester s1
// and ending in semester s2. t is one of the title constants
// and not on leave
public TitleTime(int t, Semester s1, Semester s2) {
	firstSemester= s1;
	lastSemester= s2;
	title= t;
	status= NOLEAVE;
	}
	
// Constructor: a time at title t, status st, beginning in semester s1
// and ending in semester s2. t is one of the title constants
// and not on leave
public TitleTime(int t, int st, Semester s1, Semester s2) {
	firstSemester= s1;
	lastSemester= s2;
	title= t;
	status= st;
	}
		
// a String version of title
static public String makeTitle(int title) {
	switch(title) {
		case LECTURER:   return "Lecturer";
		case SRLECTURER: return "Sr. Lecturer";
		case INSTRUCTOR: return "Instructor";
		case ASSTPROF:   return "Assis. Prof.";
		case ASSOCPROF:  return "Assoc. Prof.";
		case FULLPROF:   return "Full Prof.";
		case EMERITUS:   return "Prof. Emeritus";
		case FIELD:      return "Field Member";
		}
	return "Error. unknown";
	}
	
// Set the leave status to st (one of the three status constants)
public void setStatus(int st)
	{status= st;}
	
// a String version of the title of this TitleTime
public String makeTitle() {
	switch(title) {
		case LECTURER:   return "Lecturer";
		case SRLECTURER: return "Senior Lecturer";
		case INSTRUCTOR: return "Instructor";
		case ASSTPROF:   return "Assistant Professor";
		case ASSOCPROF:  return "Associate Professor";
		case FULLPROF:   return "Full Professor";
		case EMERITUS:   return "Professor Emeritus";
		case FIELD:      return "Field (but not dept.) Member";
		}
	return "Error. unknown";
	}
	
// A String version of the status during this period
// it is empty for a 
public String makeStatus() {
	if (status == NOLEAVE) return "noleave";
	if (status == SABBATIC) return "sabbatic";
	if (status == OTHERLEAVE) return "leave";
	return "Error: status unknown";
	}
	
// A String version of this TitleTime
public String toString() {
	return makeTitle() + " " + makeStatus() + " " +
		   firstSemester + "--" + lastSemester;
	}
	
// = the Color for this title
public Color titleColor() {
	switch(title) {
		case LECTURER:  return new Color(52,236,2);
		case SRLECTURER:return new Color(2,140,12);
		case INSTRUCTOR:return new Color(56,50,247);
		case ASSTPROF:  return new Color(250,173,110);
		case ASSOCPROF: return new Color(250,44,28);
		case FULLPROF:  return new Color(149,14,4);
		case EMERITUS:  return new Color(89,89,89);
		case FIELD:     return new Color(104,217,249);
		}
	return Color.black;
	}

// = the Color for title t (one of the above constants)
static public Color titleColor(int t) {
	TitleTime temp= new TitleTime(t,null,null);
	return temp.titleColor();
	}
}