// A representation of a semester
// (e.g. Fall 1997 or Spring 1998)
public class Semester {
private int yr;  	// four-digit year, e.g. 1998
private int sem;   	// 0= spring, 1= fall

// Constructor --initialized to S 0000
public Semester() {
	yr= 0;
	sem= 0;
	}
	
// Constructor --the semester that is in month m and year y.
// Months 0..5 are the spring semester; months 6..11, fall semester
public Semester(int m, int y) {
	yr= y;
	if (m <= 5) sem= 0;
	else		sem= 1;
	}
	
// Yield the semester, as a String "F" or "S"
public String semester() {
	if (sem == 0) return "S";
	return "F";
	}
	
// Set the semester to t (which is "F" or "S")
public void setSemester(String t) {
	if (t.equals("S"))
		 sem= 0;
	else sem= 1;
	}
	
// Yield the year
public int year()
	{return yr;}
	
// Set the year to i
public void setYear(int i) {
	yr= i;
	}
	
// = Semester s1 comes before or is the same as Semester s2
static public boolean lesseq (Semester s1, Semester s2) {
	if (s1.year() < s2.year()) return true;
	if (s1.year() > s2.year()) return false;
	return s1.sem <= s2.sem;
	}
	
// = Semester s1 comes before Semester s2
static public boolean less (Semester s1, Semester s2) {
	if (s1.year() < s2.year()) return true;
	if (s1.year() > s2.year()) return false;
	return s1.sem < s2.sem;
	}
	
// = Semesters s1 and s2 are the same
static public boolean equals (Semester s1, Semester s2) {
	return s1.yr == s2.yr && s1.sem == s2.sem;
	}
	
// = the Semester following this Semester
public Semester next() {
	Semester s= new Semester();
	s.yr= this.yr;
	s.sem= 1 - this.sem;
	if (s.sem == 0)
		s.yr= s.yr+1;
	return s;
	}
	
// = the number of Semesters between Semesters s1 and s2  --i.e.
//   the number of times s1.next() is to be executed to get to s2
//   (Precondition: lesseq(s1, s2); otherwise, 0 is returned)
static public int difference (Semester s1, Semester s2) {
	if (less(s2,s1)) return 0;
	if (s1.sem == s2.sem)
		return 2*(s2.yr - s1.yr);
	return 1 + 2*(s2.yr - s1.next().yr);
	}
	
// = the minimum of Semesters s1 and s2
static public Semester min(Semester s1, Semester s2) {
	if (lesseq(s1,s2)) return s1;
	return s2;
	}

// = the maximum of Semesters s1 and s2
static public Semester max(Semester s1, Semester s2) {
	if (lesseq(s1,s2)) return s2;
	return s1;
	}
	
// = a String version of this Semester
public String toString() {
	if (sem == 0) return "S" + yr;
	return "F" + yr;
	}
	
}
	