// Provide methods for iterating over objects
// in a LinkedList list
public class LinkedListIterator extends LinkedList {

// change the current node to the beginning of the list
public void reset()
	{node = head; index = 0;}

private LinkedListNode head; 	// head of the list
private LinkedListNode node;  	// current node to be processed
								// (null if none)
private int index;            	// index of current node (first is 0)
 
//Constructor: to iterate over list s
public LinkedListIterator(LinkedList s)
	{head = s.head; node= head; index= 0;}

// = "current node is non-null"
public boolean okay()
	{return node != null;}

// = value of current node --call only if node is non-null
public Object data()
	{return node.m_value;}
	
// = change the current node to the next one in the list
//   (or null if there is no next one)
public void next()
	{node = node.m_next; index++;}

// = index of current element (0 if past end of list)
public int GetIndex() {
	if (node != null) return index;
	return 0;
	}

}

