
// Class of the base of a linked list, with head/tail
// pointers, with objects that are owned by the list
public class LinkedList 
{protected LinkedListNode head;  //Head pointer
 protected LinkedListNode tail;  //Tail pointer
 protected int sizex;            //No. elements in list

 // Constructor: an empty list
 public LinkedList()
	{head=null;tail=null; sizex=0;}

 // Constructor: a list with one node with value v
public LinkedList(Object v)
	{head = new LinkedListNode(v); tail = head; sizex= 1;}

 // Prepend v to list
public void prepend (Object v) {
	LinkedListNode n = new LinkedListNode(v);
	n.m_next = head;
	if (head == null)
		tail = n;
	head = n;
	sizex++;
	}

// Change the value of the first entry of the
// nonempty list to v
public void change (Object v)
	{head.m_value = v;}

 // Append v to list
 public void append (Object v) {
 	if (head == null)
		{head = new LinkedListNode(v); tail = head;}
	else {tail.m_next = new LinkedListNode(v);
		  tail = tail.m_next;}
	sizex++;
	}

 // Remove first element of list and return it --return
 // null if list is empty
 public Object remove() {
 	if (head == null)
		{return null;}
	Object v = head.m_value;
	head = head.m_next;
	sizex--;
	if (head==null) tail=null;
	return v;
    }

 // = first element of list (or null if list is empty)
 // It should not be changed, but only inspected
 public Object inspect() {
 	if (head==null) return null;
	return head.m_value;
	}

 // = element n of the list (or null if not possible
 // Precondition: 0<= n< this.size()
 public Object inspect(int n) {
 	int i= 0;
	LinkedListNode p= head;
	// Invariant: p is a pointer to the part of the list that follows
	// the first i elements (null means that the following part is empty)
	while (i<n && p != null)
		{i= i+1; p= p.m_next;}
	if (p == null) 
		return null;
	return p.m_value;
	}

 // = last element of list (or null if list is empty)
 // The element should not be changed, but only inspected
 public Object inspectLast() {
 	if (head==null) return null;
	return tail.m_value;
	}

 // = "list is empty
 public boolean isEmpty()
	{return head==null;}

 // = size of list
 public int size()
	{return sizex;}

 // Set the list to an empty list
 public void clear()
	{head = null; tail = null; sizex = 0;}

// Return the list but truncated to its first n elements
// Precondition: 0 <= n <= this.size()
public LinkedList truncate(int n) {
	if (n==0) {
		this.clear();
		return this;
		}

	sizex= n;
	// Set tail to point to element number n-1 (and set n to 1)
		tail= head;
		while (n!=1) {
			n= n-1; tail= tail.m_next;
			}
	tail.m_next= null;
	return this;
	}

// Remove and return last element of the list (return null
// if none). This method is inefficient, because of the
// list's structure.
public Object removeLast ()	{
	if (sizex == 0)
		return null;
	
	if (sizex == 1) {
		LinkedListNode temp = head;
		Object result = head.m_value;
		head = null;
		tail = null;
		sizex = sizex-1;
		return result;
		}
   
	LinkedListNode temp   = head;
    Object result = tail.m_value;

    while (temp.m_next != tail)
		temp = temp.m_next;
    temp.m_next = null;
    tail = temp;
    sizex = sizex-1;
    return result;
	}

// a printable version of the elements of this LinkedList
// --assuming that toString() works for its elements
public String toString() {
	LinkedListIterator iter= new LinkedListIterator(this);
	int i= 0;
	String s= "(";
	while (iter.okay())
		{if (i!=0)
			s= s + ", ";
		i= i+1;
		s= s+ iter.data();
		iter.next();}
	return s + ")";
	}

 }