import java.util.*;

// A tokenizer that reads integers and "words", where a word
// is either a sequence of non-whitespace characters or a string "..".
public class GriesTokenizer extends StringTokenizer {

// Constructor --tokenize s
public GriesTokenizer(String s) {
	super(s,"\n\t\r ");
	}

// return the next token as an integer
public int nextIntToken() {
	String s = super.nextToken();
	if (!isDigits(s))
		return -1;
	return Integer.parseInt(s);
	}
	
// = s consists solely of digits 0..9
static public boolean isDigits(String s) {
	for (int i= 0; i != s.length(); i= i+1) {
		if (s.charAt(i) < '0') return false;
		if (s.charAt(i) > '9') return false;
		}
	return true;
	}
	
// return the next word --as explained above. The string ".." business is
// not checked out.
public String nextWord() {
	String s= nextToken();
	if (s.charAt(0) != '"')
		return s;
	// Word begins with ", so parse a real string
		s= s.substring(1);
		while (s.charAt(s.length()-1) != '"')
			{s= s + " " + nextToken();
			}
	return s.substring(0,s.length()-1);
	}

}

