/* This applet displays the faculty over a period of years. The user can
   determine the range of years to see and the order of the list (sorted
   by name, first year, last year, or length of service).
   
  The faculty appear in file faclist.txt, a resource that must be in the
  same directory as this applet. The faculty appear in faclist.txt in any
  order. For each person, give the following information:
   
       Name, with character '=' instead of a blank --the name may
       not contain a blank.
   		
       Description of a period of service.     	(These descriptions must
       Description of next period of service.	appear in chronological
       ...										order and have no overlap)
       Description of last period of service.
       A period "."
   
 A description of a period of service consists of:
 
 	   An optional leave thing: "SAB" for sabbatic and "LEA" for other leaves
   
       A title: "L" for lecturer,
       			"SL" for senior lecturer,
       			"I"  for instructor,
                "A1" for assistant professor,
                "A2" for associate professor,
                "FP" for full professor,
                "EP" for professor emeritus
                "F"  for a member of the Field of CS who is not a member
                     of the department
      The first semester of the period  (e.g. F 1989  or  S 1965)
      The last semester of the period (e.g. S 1989). If the last semester is
      	the current one and the person is expected to be on the faculty
      	in the next semester, use "present" for the last semester.
      
   SEPARATE EACH PIECE OF DATA BY AT LEAST ONE BLANK OR BY AN END-OF-LINE.
   
   David Gries, Computer Science, Cornell University, Ithaca, NY 14853
   gries@cs.cornell.edu
*/

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import java.util.*;

public class FacultyApplet extends Applet
						   implements ActionListener,
						    		AdjustmentListener {
CSCanvas c;				// The canvas that goes in ScrollPane sp
Scrollbar scrollV;    	// The vertical scrollbar for canvas c
Scrollbar scrollH;    	// The horizontal scrollbar for canvas c
int previousValueV= 0;		// Last interrogated value of scrollV
int previousValueH= 0;		// Last interrogated value of scrollH

static Font font;			// the font being used to draw the graph
static FontMetrics fontM;	// the FontMetrics for Font font
static int widthOne;		// 2 + (width of any digit in Font font)
static int fontHeight;      // The height of a line in the font

// Layout and constraint variables for the frame
	GridBagLayout gbl;
	GridBagConstraints gbc;
	
	GridLayout gl;
	
// Components for the applet
	Panel p1; 	//contains the following
	static Label label1= new Label(" CS FACULTY OVER THE YEARS!   ", Label.RIGHT);
	static Label label2= new Label("Choose a range of years and a sort key and press OK.   ",
	                          	Label.LEFT);
	                          	
	Panel p1a;	//contains the following
	static Label label3= new Label("   To sort on x with secondary keys y and z, first sort on z, then y, then x.",
	                          	Label.LEFT);
	                          	
    Panel p2;  	//contains the following
	static Label labelSort= new Label("Sort by:", Label.RIGHT);
	static Label labelFirst= new Label("First:", Label.LEFT);
	static Label labelLast= new Label("Last:", Label.LEFT);

	// Variables for determining the method of sorting the faculty.
	//Sort By name, first year, last year, time of service, or title
		static Choice choiceSort; 
		static String[] sorts=  {"name", "first semester", "last semester",
							  "time in dept.", "title"};
		static Choice fYear; // Restrict the selection to the faculty
		static Choice lYear; // present in years fYear..lYear
		static Button buttonOK= new Button("OK");
		static Button buttonAbout= new Button("About ...");
	
private AboutDialog ab=  null;

// Called by the system to start the applet
public void init() {	
	font= new Font("Monospaced", Font.PLAIN, 10);
	FontMetrics fontM= getFontMetrics(font);
	widthOne= 2+fontM.charWidth('1');
	fontHeight= fontM.getHeight();
	
	// Create the layout manager for the applet
		gbl= new GridBagLayout();
		gbc= new GridBagConstraints();
		setLayout(gbl);
		gbc.fill= GridBagConstraints.BOTH;

	// Add the text to panel p1		
		p1 = new Panel();
		p1.add(label1);
		p1.add(label2);
		
	// Add the text to panel p1a
		p1a= new Panel();
		p1a.add(label3);

	p2 = new Panel();
		
	// Add the first-year part of the GUI
		p2.add(labelFirst);
		fYear= new Choice();
		for (int i= 1965; i != 1999; i= i+1)
	  	  fYear.add(String.valueOf(i));
		fYear.select(0);
		p2.add(fYear);
	
	// Add the last-year part of the GUI
		p2.add(labelLast);
		lYear= new Choice();
		for (int i= 1965; i != 1999; i= i+1)
		    lYear.add(String.valueOf(i));
		lYear.select(1998-1965);
		p2.add(lYear);
	
	// Add the sorting part of the GUI
		p2.add(labelSort);
		choiceSort= new Choice();
		for (int i= 0; i!=sorts.length; i= i+1)
			choiceSort.add(sorts[i]);
		choiceSort.select(0);
		p2.add(choiceSort);
	
	// Add the OK button, not allowing it to change size
		p2.add(buttonOK);
		buttonOK.addActionListener(this);
		
	// Add the About ... button, not allowing it to change size
		p2.add(buttonAbout);
		buttonAbout.addActionListener(this);
		
		//Panel p3 = new Panel();
		//.setLayout(new GridLayout(0, 1));
		add(p1,gbl, gbc,  0,0, 2,1, 100,0);
		add(p1a,gbl,gbc,  0,1, 2,1, 100,0);
		add(p2,gbl, gbc,  0,2, 2,1, 100,0);

	// Add a Canvas c)
		//sp= new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
		c= new CSCanvas(this);
		c.setBackground(new Color(250,250,210));
		
		Dimension appletSize= this.getSize();
		int paneHeight= appletSize.height - 150 - 75;  // For the top
		int paneWidth=  appletSize.width-50;
		//sp.setSize(paneWidth, paneHeight);
		
	// Calculate sizes using the settings in the three choice boxes
		int  s= choiceSort.getSelectedIndex();
		int fy= Integer.parseInt(fYear.getSelectedItem());
		int ly= Integer.parseInt(lYear.getSelectedItem());
		// If the selected first year is greater than the selected first year,
		// change the last year to first year and change the selection accordingly.
			if (fy > ly) {
				ly= fy;
				lYear.select(fYear.getSelectedItem());
				}
	
	add(c, gbl, gbc, 0,3, 1,1, 100,100);
	c.recalculate(s, fy, ly);
		
	// Add the two scrollbars
		scrollV= new Scrollbar(Scrollbar.VERTICAL,0,0,0,c.bigFaculty.size());
		add(scrollV, gbl, gbc, 1,3, 1,1, 0, 100);
		scrollV.addAdjustmentListener(this);
		
		int sems= Semester.difference(c.firstSem,c.lastSem) + 1;
		
		scrollH= new Scrollbar(Scrollbar.HORIZONTAL,0,0,0,sems);
		add(scrollH, gbl, gbc, 0,4, 1,1, 100, 0);
		scrollH.addAdjustmentListener(this);
	
	repaint();
	}
	
public void adjustmentValueChanged(AdjustmentEvent evt) {
	int valueV= scrollV.getValue();
	int valueH= scrollH.getValue();	
	if ((valueV != previousValueV) || (valueH != previousValueH)) {
		c.repaint();
		previousValueV= valueV;
		previousValueH= valueH;
		}
	}

// Dispose of Frame d (called by the system before it destroys the applet)
public void destroy() {
	if (ab != null) ab.dispose();
	}
	
// Add component c to gbl (with constraints gbc) at position (x,y).
// Component c takes w columns and r rows and is weighted (wx, wy)
private void add(Component c, GridBagLayout gbl, GridBagConstraints gbc,
                 int x, int y, int w, int h, int wx, int wy) {
	gbc.gridx= x;
	gbc.gridy= y;
	gbc.gridwidth= w;
	gbc.gridheight= h;
	gbc.weightx= wx;
	gbc.weighty= wy;
	gbl.setConstraints(c, gbc);
	add(c);
	}
	
// Process click of buttons: Redraw the faculty-line frame using
// the settings in the three choice boxes
public void actionPerformed(ActionEvent evt) {
	String arg= evt.getActionCommand();
	if (arg.equals("OK")){
		//Recalculate and set GUI sizes using
		// the settings in the three choice boxes
			int  s= choiceSort.getSelectedIndex();
			if      (s==0)	s= CSCanvas.BYNAME;
			else if (s==1)	s= CSCanvas.BYFIRSTSEMESTER;
			else if (s==2) 	s= CSCanvas.BYLASTSEMESTER;
			else if (s==3) 	s= CSCanvas.BYLENGTH;
			else            s= CSCanvas.BYTITLE;
			
			int fy= Integer.parseInt(fYear.getSelectedItem());
			int ly= Integer.parseInt(lYear.getSelectedItem());
			// If the selected first year is greater than the selected first year,
			// change the last year to first year and change the selection accordingly.
				if (fy > ly) {
					ly= fy;
					lYear.select(fYear.getSelectedItem());
					}
			c.recalculate(s, fy, ly);
				
	 	scrollV.setValue(0);        	  
		scrollH.setValue(0);
		
		c.repaint();
		return;
		}
	if (arg.equals("About ...")) {
		if (ab == null)
			ab= new AboutDialog();
			ab.show();
		return;
		}
	}
}

