// Record of a faculty member:
// name and a list of time periods with titles.
// These must be in chronological order and must not overlap.
public class Faculty {
public String name;
public LinkedList periods; //A linked list of periods of the faculty member. There
			// is more than one element either because the member was in service at
			// noncontiguous periods or because their title changed. Elements of
			// the linked list are of type TitleTime.
public int lastTitle; // The last title for this faculty member in the
					  // range associated with the array in which it appears

// Constructor --a faculty member with name n, title t, first Semester s1,
// 				 and last semester s2. t is a constant defined in class TitleTime
public Faculty(String n, int t, Semester s1, Semester s2) {
	name		 = n;
	periods= new LinkedList(new TitleTime(t, s1, s2));
	}
	
// Constructor --a faculty member with name n, title t, status st, first Semester s1,
// 				 and last semester s2. t is a constant defined in class TitleTime
public Faculty(String n, int t, int st, Semester s1, Semester s2) {
	name		 = n;
	periods= new LinkedList(new TitleTime(t, st, s1, s2));
	}

// Constructor --a faculty member with name n, title t, leave-status st,
//               first Semester (t1,s1),
//				 and last semester (t2,s2). s1,s2 are years; t1,t2, "F" or "S".
//				 t is one of the size constants of class TitleTime
public Faculty(String n, int t, String t1, int st, int s1, String t2, int s2) {
	Semester firstSemester;
	Semester lastSemester;
	name= n;
	if (t1.equals("S"))
		 firstSemester= new Semester(0, s1);
	else firstSemester= new Semester(6, s1);

	if (t2.equals("S"))
		 lastSemester= new Semester(0, s2);
	else lastSemester= new Semester(6, s2);
	periods= new LinkedList(new TitleTime(t, st, firstSemester, lastSemester));
	lastTitle= t;
	}
	
// Add a new period for this person --title t, status st, first semester s1, and
// 			   	second semester s2
public void addPeriod(int t, int st, Semester s1, Semester s2) {
	periods.append(new TitleTime(t, st, s1, s2));
	lastTitle= t;
	}
	
// = String version of this faculty member
public String toString() {
	String res= name;
	LinkedListIterator iter= new LinkedListIterator(periods);
	while (iter.okay()) {
		TitleTime tt= (TitleTime)iter.data();
		res= res + " " + tt.toString();
		iter.next();
		}
	return res;
	}
	
// = First semester for this faculty member
public Semester firstSemester() {
	return ((TitleTime)periods.inspect()).firstSemester;
	}
	
// = Last semester for this faculty member
public Semester lastSemester() {
	return ((TitleTime)periods.inspectLast()).lastSemester;
	}
	
// = Number of semesters at Cornell (Does not count non-sabbatical leaves)
public int numSemesters() {
	int num= 0;
	LinkedListIterator iter= new LinkedListIterator(periods);
	while (iter.okay()) {
		TitleTime tt= (TitleTime)iter.data();
		if (tt.status != TitleTime.OTHERLEAVE)
			num= num + Semester.difference(tt.firstSemester,tt.lastSemester) + 1;
		iter.next();
		}
	return num;
	}
	
// = the last title for the faculty member that within the bounds of the currently
//    displayed years
//   Precondition: at least one semester of the faculty member is within the bounds
public int lastTitle() {
	int ans= 0;
	LinkedListIterator iter= new LinkedListIterator(periods);
	// Invariant and is the last title within bounds for the elements of periods
	// looked at thus far (0 if none)
	while (iter.okay()) {
		TitleTime tt= (TitleTime)iter.data();
		if (CSCanvas.isWithin(tt))
			ans= tt.title;
		iter.next();
		}
	return ans;
	}
	
}