// A dynamic array of elements of class Faculty
public class DynArray
{
private Faculty [] b;	// 0<=sz<=b.length. The faculty are
private int sz;    		// in b[0..sz-1]

// sort0, sort1, and sort2 are used to define a sorting order.
// Each is one of the values CSCanvas.BYNAME--CS_Canvas.BYTITLE
// When an array is to be sorted, these values are used: sort0 defines
// the first sort key, sort1 the second, and sort2 the third.  These
// variables are static so that, when a copy is made of the array,
// the current values are used. They are chnaged in method sort.
private static int sort0= CSCanvas.BYNAME;  // Initally, all say sort on name
private static int sort1= CSCanvas.BYNAME;
private static int sort2= CSCanvas.BYNAME;

// Constructor: an array of 0 elements but allocation 10
public DynArray() {
	b= new Faculty[10];
	sz= 0;
	}
		
// Add element f to the array
public void add(Faculty f) {
	if (sz == b.length)
		{// Reallocate the array with twice as many elements}
			Faculty [] bTemp= b;
			b= new Faculty[b.length * b.length];
			if (sz > 0)
				System.arraycopy(bTemp,0,b,0,sz);
		}
	b[sz]= f;
	sz= sz+1;
	}
	
// = element i of the array
// Precondition: 0<=i<sz
public Faculty element(int i)
	{return b[i];}

// = number of filled elements in the array (not the number allocated)
public int size()
	{return(sz);}
	
// = String verson of elements of the array
public String toString() {
	StringBuffer s= new StringBuffer();
	int i= 0;
	while (i!= sz) {
		s= s.append("\n" + b[i]);
		i= i+1;
		}
	return s.toString();
	}
	
// Swap b[i] and b[k]
public void swap(int i, int k) {
	Faculty temp= b[i]; b[i]= b[k]; b[k]= temp;
	}
	
// Remove element i from the array (put the last element in its place)
// It is assumed that 0 <= i < this.size().
public void remove(int i) {
	b[i]= b[sz-1];
	sz= sz-1;
	}
	
// = "x came before y"
static public boolean cameBefore(Faculty x, Faculty y) {
	return Semester.less(x.firstSemester(), y.firstSemester());
	}
	
// = x left before y
static public boolean leftBefore(Faculty x, Faculty y) {
	return Semester.less(x.lastSemester(), y.lastSemester());
	}

// sort0,sort1,sort2:= sortChoice,sort0,sort1, where sortChoice is
// one of the values CSCanvas.BYNAME--CSCanvas.BYTITLE.
// Then sort this array based on sort0, sort1, sort2
public void sort(int sortChoice) {
	sort2= sort1;
	sort1= sort0;
	sort0= sortChoice;
	quickSort();
	}
	
// = a copy of the array
public DynArray copy() {
	DynArray c= new DynArray();
	for (int i= 0; i != this.sz; i= i+1) {
		c.add(b[i]);
		}
	return c;
	}
	
// = the number of faculty in the array whose lastTitle field is tt
public int numTitle(int tt) {
	int n= 0;
	for (int i= 0; i != sz; i= i+1)
		if (element(i).lastTitle == tt)
			n= n+1;	
	return n;
	}

// 0 <= h < k-1 < this.size(). Let x some value in this[h..k-1]
// Permute this[h..k-1] and return a value p such that
// this[h..p-1] <= x = p <= this[p+1..k-1]
public int partition(int h, int k) {
	// Permute this.h, this[(h+k)/2], this[k-1] so that b.h is the median
		//(code still to be written)
	int q= h+1;
	int p= k-1;
	// invariant: this.h=x, this[h+1..q-1]<=x, and this[p+1..k-1]>=x
	while (q <= p) {
		if 		(lessTest(q,h)) q= q+1;
		else if (lessTest(h,p)) p= p-1;
		else				{swap(p,q);q= q+1; p= p-1;}
		}
	if (p+2 == q) p= p+1;
	// Result: this.h=x, this[h+1..p]<=x, this[p+1..k-1]>=x
	swap(h,p);
	return p;
	}

// Sort this array, inplace, using Quicksort, where based on globals s0 and s1
public void quickSort() {
	LinkedList t= new LinkedList(new Coordinates(0, this.size()));
	// Invariant: The array is sorted if each of the segments
	//             this[e.x .. e.y-1] are sorted for e an element of t
	while (t.size() != 0) {
		Coordinates co= (Coordinates)t.remove();
		int h= co.x;
		int k= co.y;
		if (k==h) {}                          		// Partition of size 0
		else if (k-h<=2) {
				if (lessTest(k-1,h)) swap(k-1,h);   // Partition of size 1 or 2
				}
		else {                                 		// Partition of size > 2
			int j= partition(h,k);
			// this[h..j-1]<=this.j<=this[j+1..k-1]
			// Place the larger of the two segments on t first, then the smaller
				if (k-j-1 > j-h) {
					t.prepend(new Coordinates(j+1,k));
					t.prepend(new Coordinates(h,j));
					}
				else {
					t.prepend(new Coordinates(h,j));
					t.prepend(new Coordinates(j+1,k));
					}
			}
		}
	}
	
//= b[i]<b[j], where < is defined depending on s:
// 0=name,1=title,2=first sem, 3=last sem, 4=length of stay
public boolean less(int i, int j, int s) {
	switch (s) {
		case CSCanvas.BYNAME: return b[i].name.compareTo(b[j].name) < 0;
		case CSCanvas.BYTITLE: return b[j].lastTitle < b[i].lastTitle;
		case CSCanvas.BYFIRSTSEMESTER: return cameBefore(b[i],b[j]);
		case CSCanvas.BYLASTSEMESTER: return leftBefore(b[j],b[i]);
		case CSCanvas.BYLENGTH: return b[j].numSemesters()<b[i].numSemesters();
		}
	return true;
	}
	
// = b[i]<b[j], where < is defined depending on sort0, sort1, sort2 (see
// their definition)
public boolean lessTest(int i, int j) {
	if (less(i,j,sort0)) return true;
	if (less(j,i,sort0)) return false;
	// b[i] = b[j] on first key
	if (less(i,j,sort1)) return true;
	if (less(j,i,sort1)) return false;
	// b[i] = b[j] on second key
	return less(i,j,sort2);
	}
	
}