import java.awt.*;
import java.io.*;
import java.util.*;
import java.applet.Applet;

// The canvas that contains the displayed faculty
public class CSCanvas extends Canvas {

static FacultyApplet drawing;			// The Applet on which the Scroll Pane is placed
static int length;      // virtual length of this canvas
static int width;       // virtual width of canvas
static int maxTitleWidth; // the width of the largest title (20 characters)

static Graphics m_g;  		// The graphics instance for the applet
static Font font;			// the font being used to draw the graph
static FontMetrics fontM;	// the FontMetrics for Font font
static int fontHeight;      // The height of a line in the font
static int charWidth;		// Width of one character
static int widthOne;		// 2 + (width of any digit in Font font)

static Semester firstPossibleSem; 	// The first possible semester under consideration
static Semester lastPossibleSem;	// The current semester (determined using the
									// computer's clock)

static Semester firstSem;			// The first and last semesters
static Semester lastSem;			// to be displayed
static Semester firstSemScrolled;	// The first semester to display on the scrolled
                           			 // canvas
// The buffer in which to draw the image; used for double buffering.
    Image backBuffer;
// The graphics context to use when double buffering.
    Graphics backG;
    
//  0 by name, 1 by first semester, 2 by last semester,
//  3 by length of service, 4 by title
static public final int BYNAME= 		0;
static public final int BYFIRSTSEMESTER=1;
static public final int BYLASTSEMESTER= 2;
static public final int BYLENGTH= 		3;
static public final int BYTITLE= 		4;

static int sortMethod= BYNAME;	// The current sorting method: 
	
static int beginx;     		// x-coordinate for first pixel in table for semester firstSem
static int beginy;   		// beginning vertical position to draw the faculty
static int startVerticals;  // The vertical position to start the vertical lines
static int liney;			// vertical pos. of next line to draw in the display
static int beginFaculty; 	// y-coordinate for the first pixel of faculty data

static Color colorNames= new Color(16, 4,177); // The color in which the names are painted
	
static DynArray bigFaculty;    // the array of all faculty
static DynArray faculty;       // the array of faculty being displayed

static boolean error= false;  	// = an error was found during parsing
static String message1= "";		// The messages to be printed if an error occurs
static String message2= "";		// in parsing the input

// Constructor: A canvas for ScrollPane s on frame d
public CSCanvas(FacultyApplet d) {
	super();
	drawing= d;
	setBackground(new Color(250,250,210));
	
	// Set up the last possible semesters and set the last display semester to it.
		GregorianCalendar todaysDate= new GregorianCalendar();
		lastPossibleSem= new Semester(todaysDate.get(Calendar.MONTH),
							   	   todaysDate.get(Calendar.YEAR));
		lastSem= new Semester(todaysDate.get(Calendar.MONTH),
							  todaysDate.get(Calendar.YEAR));
			   	   
	// Read the faculty into array BigFaculty.
		bigFaculty= parse();
 	if (bigFaculty != null) {
 		faculty= bigFaculty.copy();
		faculty.sort(BYFIRSTSEMESTER);
		// Set the first possible semester and the first display semester to the
		// first faculty member's first semester
			firstPossibleSem= faculty.element(0).firstSemester();
			firstSem= firstPossibleSem;
		faculty.sort(BYNAME);
		}
	
	font= new Font("Monospaced", Font.PLAIN, 10);
	FontMetrics fontM= getFontMetrics(font);
	charWidth= fontM.charWidth('1');
	widthOne= 2+charWidth;
	fontHeight= fontM.getHeight();
	
	beginy= 6*fontHeight+ 5;
	beginx= 150;
	liney= fontHeight;
	startVerticals= 6*fontHeight;

	//Calculate the width and height of the canvas
		length= fontHeight*(5+faculty.size()) + 5;
		int diff= Semester.difference(firstSem,lastSem);
		width= beginx + (diff+1)*widthOne + 2 * widthOne + beginx;
	
	maxTitleWidth= 20*fontM.charWidth('1');
	}

// Paint the canvas (by updating)
public void paint( Graphics g) {
	update(g);
	}

// Paint Graphics g with the faculty
public void paintCanvas(Graphics g) {
	m_g= g;
	if (error) {// An error message occurred. print it and return
		m_g.drawString("Sorry, there is an error in the input.", 2, liney);
		m_g.drawString(message1, 2, liney + fontHeight);
		m_g.drawString(message2, 2, liney + 2*fontHeight);
		}
		
	// Calculate the first semester, firstSemScrolled, to appear in the
	// horizontally scrolled canvas
		firstSemScrolled= firstSem;
		int temp= drawing.scrollH.getValue();
		for (int i=0; i< temp; i= i+1) firstSemScrolled= firstSemScrolled.next();
	
	liney= fontHeight;
	paintLegend();
	printHeaders(3*liney);
	
	beginy= 6*fontHeight+5;
	liney= beginy;
	drawFaculty(faculty);
	drawVerticals();
}

// Update Graphics g, using backbuffer if not null
public void update(Graphics g) {
    // Get width and height of canvas
       	int w = getBounds().width;
        int h = getBounds().height;
    
    // If there is no Image, create one
        if (backBuffer == null
            || backBuffer.getWidth(null) != w
            || backBuffer.getHeight(null) != h) {
            backBuffer = createImage(w, h);
            if (backBuffer != null) {
                // Get rid of any old Image
                	if (backG != null) {
                    	backG.dispose();
                	}
                backG = backBuffer.getGraphics();
            }
        }
        
	if (backBuffer != null) {
    	// Fill in Graphics context backG.
            backG.setColor(new Color(250,250,210));
            backG.fillRect(0, 0, w, h);
            paintCanvas(backG);
            
     	// Copy the new image to g.
            g.drawImage(backBuffer, 0, 0, null);
        }
            
    }

// Print the headers using Graphics m_g for the table at vertical position liney
static public void printHeaders(int liney)
	{Color saveColor= m_g.getColor();
	m_g.setColor(Color.black);
	Semester s= firstSemScrolled; int xF= beginx;
	//invariant: Semesters less than s have been printed;
	//           the "F" or "S" for the semester goes at horizontal
	//           position xF and vertical position beginy
	while (Semester.lesseq(s, lastSem)) {
		//Paint the header for year i
			m_g.drawString(s.semester(), xF+1,liney);
				
			int j= s.year() % 100;
			m_g.drawString(new Integer((j-j%10)/10).toString(),xF,liney+fontHeight);
			m_g.drawString((new Integer(j%10)).toString(),xF,liney+2*fontHeight);
		xF= xF + widthOne;
		s= s.next();
		}
	liney= liney+3*fontHeight;
	m_g.setColor(saveColor);
	}
	
// Paint the elements of faculty beginning at vertical position liney
// and advance liney accordingly
static public void drawFaculty(DynArray faculty) {
	Color saveColor= m_g.getColor();

	// Set i to the index of the first faculty member to paint.
	// This is the value of the vertical scrollbar.
		int i= drawing.scrollV.getValue();
	
	// Set maxi to the index of the last faculty member to paint.
		int maxi= i + (drawing.c.getBounds().height - 5) / fontHeight +1 ;
		if (maxi >faculty.size()) maxi= faculty.size();
	
	// Invariant: i faculty have been painted, and number i goes at
	// y-coordinate liney
	while (i != maxi) {
		paintFaculty((Faculty)faculty.element(i));
		i= i+1;
		liney= liney+fontHeight;
		}
		
	m_g.setColor(saveColor);
	}
	
// Paint faculty member f
static void paintFaculty(Faculty f) {
	m_g.setColor(colorNames);
	// Draw the name, along with the number of semesters if the faculty are being sorted
	// by number of semesters
	    //Store in s the prefix of the name that fits in given space and
	    //in suffix either "" or the number of years in service
			String st= f.name;
			String suffix= "";
		if (sortMethod == BYLENGTH) suffix= " " +  f.numSemesters()/ 2.0;
		int noChars= ((beginx)/charWidth) - suffix.length() -4;
		if (st.length() > noChars)
			st= st.substring(0,noChars-1);
		m_g.drawString(st + suffix, 2, liney);
	
	// Paint the periods of service for f
	LinkedListIterator iter= new LinkedListIterator(f.periods);
	TitleTime previous= null;
	// Invariant: iter.data() is the next TitleTime to (possibly) paint for
	//            this faculty member, and previous is the previous
	//            TitleTime (null if none). TitleTimes before iter.data()
	//            have been printed.
	while (iter.okay()) {
		TitleTime tt= (TitleTime)iter.data();
		iter.next();
		TitleTime next= null;
		if (iter.okay())
			next= (TitleTime)iter.data();

		paintPeriod(previous,tt,next);
		
		previous= tt;
		}
		
	firstThreeDots(f);
	lastThreeDots(f);
	// Print the name on the right
		int diff= Semester.difference(firstSemScrolled,lastSem);
		int k= beginx + (diff+1)*widthOne + 2 * widthOne;
		m_g.drawString(f.name, k, liney);
	
	}
	
// Paint the color legend on m_g at liney. This goes on the first 5
// lines of the canvas
static public void paintLegend() {
	int liney= fontHeight;
	FontMetrics fm= m_g.getFontMetrics();
	int cm= 2;	// The current horizontal position
	m_g.drawString("No. of faculty: " + faculty.size(), cm, fontHeight*3);
	
	int noOnLine= 0;  // The number of items on the current line so far
	int tt= 1;    // A constant of class TitleTime, representing a title
	// invariant: For each title in 1..i-1 for which at least one faculty
	//            member exists, the legend and no. of
	//            faculty for that title have been printed.
	//            the next title-legend goes at horizontal position cm
	//            and vertical position liney.
	while (tt <= TitleTime.numTitles) {
		if (someoneHas(tt)) {
			// Add a legend for title tt
				int n= faculty.numTitle(tt);
				String title= TitleTime.makeTitle(tt); // the title as a String
				int num= faculty.numTitle(tt); // number of faculty with this last title
				m_g.setColor(TitleTime.titleColor(tt));
				m_g.drawString(title + " (" + num + ")  ",cm, liney);
				cm= cm + maxTitleWidth;
				noOnLine= noOnLine+1;
				if (noOnLine == 4) {
					liney= liney + fontHeight;
					noOnLine= 0;
					cm= 2;
					}
			}
		tt= tt+1;
		}
	if (someoneHasStatus(TitleTime.SABBATIC)) {
		liney= 4*fontHeight;
		cm= 2;
		m_g.drawString("sabbatic: ", cm, liney);
		cm= cm + fm.stringWidth("sabbatic: ");
		m_g.setColor(TitleTime.titleColor(TitleTime.FULLPROF));
		drawStatusLines(m_g, cm,cm+10,TitleTime.NOLEAVE, liney);
		drawStatusLines(m_g, cm+11,cm+28,TitleTime.SABBATIC, liney);
		drawStatusLines(m_g, cm+29,cm+38,TitleTime.NOLEAVE, liney);
		}
		
	if (someoneHasStatus(TitleTime.OTHERLEAVE)) {
		liney= 5*fontHeight;
		cm= 2;
		m_g.drawString("leave: ", cm, liney);
		cm= cm + fm.stringWidth("sabbatic: ");
		m_g.setColor(TitleTime.titleColor(TitleTime.FULLPROF));
		drawStatusLines(m_g, cm,cm+10,TitleTime.NOLEAVE, liney);
		drawStatusLines(m_g, cm+11,cm+28,TitleTime.OTHERLEAVE, liney);
		drawStatusLines(m_g, cm+29,cm+38,TitleTime.NOLEAVE, liney);
		}

	}
	
// Draw lines in horizontal position h1..h2 for leave status st on Graphics m_g on line liney
static public void drawStatusLines(Graphics m_g, int h1, int h2, int st, int liney) {
	if (st == TitleTime.SABBATIC) {
		}
	else {
		m_g.drawLine(h1,liney-5,h2,liney-5);
		m_g.drawLine(h1,liney-4,h2,liney-4);
		
		}

	if (st == TitleTime.OTHERLEAVE) {
		}
	else {
		m_g.drawLine(h1,liney-3,h2,liney-3);
		m_g.drawLine(h1,liney-2,h2,liney-2);
		}
	}
	
// Set the color for the first three dots for faculty f.
// Then, paint the first three dots for faculty f if at least part
// of the first time period cannot painted
static public void firstThreeDots(Faculty f) {
	TitleTime first= (TitleTime)f.periods.inspect();
	m_g.setColor(first.titleColor());
	if (isWithin(first) &&
		Semester.lesseq(firstSem,f.firstSemester()))
		return;
	m_g.drawString(" ...", beginx-16, liney-4);
	}
	
// Set the color for the title of the last time period of f.
// Then, paint the last three dots for faculty f if at least part
// of the last time period cannot painted
static public void lastThreeDots(Faculty f) {
	TitleTime last= (TitleTime)f.periods.inspectLast();
	m_g.setColor(last.titleColor());
	if (isWithin(last) &&
		Semester.lesseq(f.lastSemester(), lastSem))
		return;
	// Set k to the horizontal position for the last three dots
		int diff= Semester.difference(firstSemScrolled,lastSem);
		int k= beginx + (diff+1)*widthOne - 1;
	m_g.setColor(last.titleColor());
	m_g.drawString(" ...", k+2, liney-4);
	}
	
// Paint period tt if (part of) it is within firstSemScrolled..lastSem.
// p is the previous period (null if none) and n is the next
// period (null if none)
static public void paintPeriod(TitleTime previous, TitleTime tt, TitleTime next) {
	if (!isWithin(tt))
		return;
	// Calculate position j of beginning of line for time period tt
		Semester sTemp= Semester.max(firstSemScrolled, tt.firstSemester);
		sTemp= Semester.min(lastSem, sTemp);
		int j= beginx + Semester.difference(firstSemScrolled,sTemp)*widthOne;
		j= j+ widthOne/2 -2;
		// if the line for the previous period should be contiguous with
		// this one, subtract a bit from j so that the lines will abut
		if ((previous != null) &&
			isWithin(previous) &&
			Semester.equals(previous.lastSemester.next(),
							tt.firstSemester)) {
			j= j-widthOne/2+1;
			}
		
	// Calculate position k of end of line for time period tt
		sTemp= Semester.min(lastSem, tt.lastSemester);
		sTemp= Semester.max(firstSemScrolled, sTemp);
		int k= beginx + Semester.difference(firstSemScrolled,sTemp)*widthOne;
		k= k+widthOne/3;
		// if the line for the next period should be contiguous with
		// this one, add a bit to k j so that the lines will abut
		if ((next != null) &&
			isWithin(next) &&
			Semester.equals(next.firstSemester,
							tt.lastSemester.next())) {
			k= k+widthOne/2;
			}
	
	// Draw the lines for this period
		m_g.setColor(tt.titleColor());
		drawStatusLines(m_g, j,k,tt.status, liney);
	}
	
// = "period given by tt is at least partly within firstSem..lastSem
static public boolean isWithin(TitleTime tt) {
	if (Semester.less(tt.lastSemester,firstSem))
		return false;
	if (Semester.less(lastSem,tt.firstSemester))
		return false;
	return true;
	}
	
// = "some faculty member has title tt (a constant of class TitleTime)
//   in a period covered by firstSem..lastSem"
static public boolean someoneHas(int tt) {
	for (int i= 0; i != faculty.size(); i= i+1) {
		Faculty f= faculty.element(i);
		LinkedListIterator iter= new LinkedListIterator(f.periods);
		while (iter.okay()) {
			if (isWithin((TitleTime)iter.data()) &&
					((TitleTime)iter.data()).title == tt) {
				return true;
				}
			iter.next();
			}
		}
	return false;
	}
	
// = "some faculty member has status st (one of the status constants of TitleTime)
//   in a period covered by firstSem..lastSem"
static public boolean someoneHasStatus(int st) {
	for (int i= 0; i != faculty.size(); i= i+1) {
		Faculty f= faculty.element(i);
		LinkedListIterator iter= new LinkedListIterator(f.periods);
		while (iter.okay()) {
			if (isWithin((TitleTime)iter.data()) &&
					((TitleTime)iter.data()).status == st) {
				return true;
				}
			iter.next();
			}
		}
	return false;
	}
	
// Construct and return a DynArray with the data from input.
// The input is in file faclist.txt.
// Input must have the format described in class Facultylists
// Return null if there is an error in the input
static public DynArray parse() {
	// Read file faclist.txt into String in
		InputStream inFaclist= FacultyApplet.class.getResourceAsStream("faclist.txt");
		BufferedReader br= new BufferedReader(new InputStreamReader(inFaclist));
		StringBuffer inBuffer= new StringBuffer();
		try {
			String line;
			while ((line = br.readLine()) != null) {
				inBuffer.append(" " + line + " ");
				}
			} catch(IOException e) {}
		String in= inBuffer.toString();
		
	DynArray d= new DynArray();
	GriesTokenizer t= new GriesTokenizer(in);
	// Invariant: d contains the faculty data parsed thus far;
	//            the current token is either TT_EOF or the first datum
	//    		  for the next faculty  member to get from the input is
	//            in ttype-nval-sval
	while (t.hasMoreTokens()) {
		String name= replace(t.nextWord(),'=', ' ');
		// Read in title and leave info into title and status
			int title= readTitle(t, name);
			if (title == -1) return null;
			int status= TitleTime.NOLEAVE;
			if (title > 30) {
				status= TitleTime.OTHERLEAVE;
				title= title-30;
				}
			if (title > 15) {
				status= TitleTime.SABBATIC;
				title= title-15;
				}
		Semester s1= new Semester();
		Semester s2= new Semester();
		readPeriod(t,name,s1,s2);
		if (s1.year() == -1) return null;
		Faculty f=  new Faculty(name, title, status, s1, s2);
		title= readTitle(t,name);
		// invariant: d contains all periods for name that have been read
		//     		  in so far and title contains the next token
		//            of the input (0 for ".", -1 for error, and
		// 			  one of the constants from from TitleTime otherwise
		while (title != 0) {
			// Break title into its title and status
				if (title == -1) return null;
				status= TitleTime.NOLEAVE;
				if (title > 30) {
				status= TitleTime.OTHERLEAVE;
				title= title-30;
				}
				if (title > 15) {
				status= TitleTime.SABBATIC;
				title= title-15;
				}
			s1= new Semester();
			s2= new Semester();
			readPeriod(t,name,s1,s2);
			if (s1.year() == -1) return null;
			f.addPeriod(title, status, s1, s2);
		
			title= readTitle(t,name);
			}
		d.add(f);
		}
	return d;
	}
	
// Read and return the status and title information (or ".") from t for
// person name. The input is either
//    (0) a period "."
//    (1) one of L, SL, I, A1,A2, FP, EP, F
//    (2) SAB followed by one of L, SL, I, A1,A2, FP, EP, F
//    (3) LEA  followed by one of L, SL, I, A1,A2, FP, EP, F
// If the next title is wrong, print a message and return -1
// Because oly one value is returned, the returned value is
// coded as follows:
//    case (0) return 0
//    case (1) return the TitleTime constants for the value
//    case (2) return 15 + (TitleTime constants for the value)
//    case (3) return 30 + (TitleTime constants for the value)
static int readTitle(GriesTokenizer t, String name) {
	int ret= 0;
	String token= t.nextWord();
	if (token.equals("."))  return 0;
	if (token.equals("SAB")) {
		ret= 15;
		token= t.nextWord();
		}
	else if (token.equals("LEA")) {
		ret= 30;
		token= t.nextWord();
		}
	if (token.equals("L"))  return ret + TitleTime.LECTURER;
	if (token.equals("SL")) return ret + TitleTime.SRLECTURER;
	if (token.equals("I"))  return ret + TitleTime.INSTRUCTOR;
	if (token.equals("A1")) return ret + TitleTime.ASSTPROF;
	if (token.equals("A2")) return ret + TitleTime.ASSOCPROF;
	if (token.equals("FP")) return ret + TitleTime.FULLPROF;
	if (token.equals("EP")) return ret + TitleTime.EMERITUS;
	if (token.equals("F"))  return ret + TitleTime.FIELD;
	error= true;
	message1= " A title for " + name +
			  " is wrong; it is \"" + token + "\"";
	return -1;
	}
	
// = Last title in the range firstSem..lastSem for faculty f
// (the title is one of the constants in TitleTime)
// Precondition: at least one TitleTIme for f is within the range
static public int lastTitle(Faculty f) {
	// Store in tt the last TitleTime for f that is within firstSem..lastSem
		LinkedListIterator iter= new LinkedListIterator(f.periods);
		// Store in ps the first element of periods that is within
		// firstSem.lastSem and set iter.data() to the next one
			while (!isWithin((TitleTime)iter.data())) {
				iter.next();
				}
			TitleTime p= (TitleTime)iter.data();
			iter.next();
		
		// Change p to the last TitleTime that is within firstSem..lastSem
			//invariant: p is within firstSem..lastSem and iter.data()
			//           is the next TitleTime on the list (null if none)
			while (iter.okay() && isWithin((TitleTime)iter.data())) {
				p= (TitleTime)iter.data();
				iter.next();
				}
		return p.title;
	}
	
// Read the next time period for person name from t into s1 and s2
// If there is any error in the input, print a message and set the year of s1 to -1
static void readPeriod(GriesTokenizer t, String name, Semester s1, Semester s2) {
	String bSemester= t.nextWord();	// The first semester (F or S)
	if (!isForS(bSemester)) {
		error= true;
		message1= "A token following " + name +
			" is not \"F\" or \"S\";";
		message2= "it is \"" + bSemester + "\"";
		s1.setYear(-1);
		return;
		}
	s1.setSemester(bSemester);
	
	int bYear= t.nextIntToken();	// The first year
	if (bYear == -1) {
		error= true;
		message1= "The first year for name " + name + " is not an integer.";
		s1.setYear(-1);
		return;
		}
	s1.setYear(bYear);
			
	String eSemester= t.nextWord();	// Either the last semester (F or S)
									// or the "present"

	int eYear;						// The last year
	if (eSemester.equals("present")) {
		s2.setSemester(lastPossibleSem.semester());
		s2.setYear(lastPossibleSem.year());
		}
	else {
		if (!isForS(eSemester)) {
			error= true;
			message1= "The last semester for " + name + "is not \"F\" or \"S\";";
			message2= "it is \"" + eSemester + "\"";
			s1.setYear(-1);
			return;
			}	
		eYear= t.nextIntToken();
		if (eYear == -1) {
			error= true;
			message1= "The last year for name " + name +" is not an integer.";
			s1.setYear(-1);
			return;
			}
		s2.setSemester(eSemester);
		s2.setYear(eYear);
		}
	}
	
// = s consists solely of digits 0..9
static public boolean isDigits(String s) {
	for (int i= 0; i != s.length(); i= i+1) {
		if (s.charAt(i) < '0') return false;
		if (s.charAt(i) > '9') return false;
		}
	return true;
	}
	
// = s is "F" or "S"
static public boolean isForS(String s) {
	return (s.equals("F") || s.equals("S"));
	}
	
// = s with occurrences of c1 replaced by c2
static public String replace(String s, char c1, char c2) {
	StringBuffer t= new StringBuffer(s);
	int i= 0;
	while (i != t.length()) {
		if (t.charAt(i) == c1)
			t.setCharAt(i, c2);
			i= i+1;
		}
	return t.toString();
	}
	
// Paint vertical lines every ten semesters and after the last semester
static public void drawVerticals() {
	Color saveColor= m_g.getColor();
	m_g.setColor(saveColor.brighter());
	// y-coordinate of top of a vertical line
		int topy= startVerticals;

	int i= 0;
	int diff= Semester.difference(firstSemScrolled,lastSem);
	// Invariant: vertical lines before year i have been painted
	while (i<= diff) {
		//Calculate x-coordinate k just before semester i
			int k= beginx + i*widthOne - 1;
		m_g.drawLine(k, topy, k, liney-fontHeight);
		i= i+10;
		}
	// Paint a vertical line after the last year
		int k= beginx + (diff+1)*widthOne - 1;
		m_g.drawLine(k, topy, k,liney-fontHeight);
	m_g.setColor(saveColor);
	}
	
// Store in array faculty people from academic years fy to ly.
// Sort the faculty depending on sortChoice (a constant BYNAME .. BYTITLE)
public void recalculate(int sortChoice, int fy, int ly) {
	// Set firstSem to the first semester to deal with
		firstSem= Semester.min(new Semester(9, fy), lastPossibleSem);
	
	// Set lastSem to the last semester to deal with. Since a last year is given,
	// this is the spring semester of the following year.  But make sure it isn't
	// bigger than the last possible semester
		lastSem= Semester.min(new Semester(0, ly+1), lastPossibleSem);
		
	faculty= bigFaculty.copy();
	// Remove from faculty people not here in a semester in firstSem..lastSem
	// For each faculty member that remains, set its lastTitle to the last title
	// it has within firstSem..lastSem
		int j= 0;
		while (j != faculty.size()) {
			Faculty fac= faculty.element(j);
			boolean out= Semester.less(fac.lastSemester(), firstSem) ||
						 Semester.less(lastSem,fac.firstSemester());
			if (out) {
				faculty.remove(j);
				}
			else {
				fac.lastTitle= lastTitle(fac);
				j= j+1;
				}
			}
	
	faculty.sort(sortChoice);
	sortMethod= sortChoice;
	}

}

