
import java.awt.*;
import java.awt.event.*;
import java.io.*;

// The Frame that contains information about the applet
public class AboutDialog extends Frame {
// Layout and constraint variables for the frame
	GridBagLayout gbl;
	GridBagConstraints gbc;

//Constructor: a frame containing a text area and an ok button
public AboutDialog() {
	// Create the layout manager for the applet
		gbl= new GridBagLayout();
		gbc= new GridBagConstraints();
		setLayout(gbl);
		gbc.fill= GridBagConstraints.BOTH;
		
	// Read the "about" mesage from aboutdialog.txt and add its lines
	// to the Frame as Labels.
		InputStream inFaclist= FacultyApplet.class.
					getResourceAsStream("aboutdialog.txt");
		BufferedReader br= new BufferedReader(new InputStreamReader(inFaclist));
		int i= 1;
                add(new Label("   "), gbl, gbc, 0,0, 1,1, 0,0);
		// Lines 0..i-1 have been filled with the lines read in thus far,
		// and the next line goes in vertical cell i
		try {
			String line;
			while ((line = br.readLine()) != null) {
				add(new Label("  " + line), gbl, gbc, 0,i, 1,1, 0, 0);
				i= i+1;
				}
			} catch(IOException e) {}
	
	// Add the OK button
		Panel p= new Panel();
		Button ok= new Button("OK");
		p.add(ok);
		add(p, gbl, gbc, 0,i, 1,1, 0, 0);
	
	setBackground(new Color(250,250,210));
	
	// The following code was taken from Horstmann and Cornell's
	// CORE JAVA 1.1 Volume I - Fundamentals (Sun Microsystems Press 1997)
	ok.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent evt)
			{setVisible(false); }
		} );
			
	// The following code was taken from Horstmann and Cornell's
	// CORE JAVA 1.1 Volume I - Fundamentals (Sun Microsystems Press 1997)
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e)
			{setVisible(false);}
		} );
		
	setSize(400, 300);
	setLocation(10, 10);
	}
	
// Add component c to gbl (with constraints gbc) at position (x,y).
// Component c takes w columns and r rows and is weighted (wx, wy)
private void add(Component c, GridBagLayout gbl, GridBagConstraints gbc,
                 int x, int y, int w, int h, int wx, int wy) {
	gbc.gridx= x;
	gbc.gridy= y;
	gbc.gridwidth= w;
	gbc.gridheight= h;
	gbc.weightx= wx;
	gbc.weighty= wy;
	gbl.setConstraints(c, gbc);
	add(c);
	}
	
}

