/**
 * University - Lab 9
 * Driver program for testing people at a university
 * Author: Michael Clarkson
 * NetID: mrc26
 * Date: 7/27/00
 */
class University {

	public static void main(String[] args) {
	
		printStars();
		System.out.println("Testing Person constructors");
		
			printBlank();
			Person p1 = new Person();
			System.out.println("Default person (Unknown, 30)");
			System.out.println("" + p1);
	
			printBlank();
			Person p2 = new Person("Bob");
			System.out.println("Named person (Bob, 30)");
			System.out.println("" + p2);
			
			printBlank();
			Person p3 = new Person("Noah", 1);
			System.out.println("Fully-defined person (Noah, 1)");
			System.out.println("" + p3);

		printStars();
		System.out.println("Testing Student constructors");
		
			printBlank();
			Student s1 = new Student();
			System.out.println("Default student (Unknown, 20, 0.0)");
			System.out.println("" + s1);
	
			printBlank();
			Student s2 = new Student("John");
			System.out.println("Named student (John, 20, 0.0)");
			System.out.println("" + s2);
			
			printBlank();
			Student s3 = new Student("Carl", 18, 3.5);
			System.out.println("Fully-defined student (Carl, 18, 3.5)");
			System.out.println("" + s3);

		printStars();
		System.out.println("Testing GraduateStudent constructors");
		
			printBlank();
			GraduateStudent g1 = new GraduateStudent();
			System.out.println("Default graduate student (Unknown, 25, Unknown, 0.0)");
			System.out.println("" + g1);
	
			printBlank();
			GraduateStudent g2 = new GraduateStudent("Vera");
			System.out.println("Named graduate student (Vera, 25, Unknown, 0.0)");
			System.out.println("" + g2);
			
			printBlank();
			GraduateStudent g3 = new GraduateStudent("Marcos", 28, "CS", 4.0);
			System.out.println("Fully-defined graduate student (Marcos, 28, CS, 4.0)");
			System.out.println("" + g3);
			
		printStars();
		System.out.println("Testing Faculty constructors");
		
			printBlank();
			Faculty f1 = new Faculty();
			System.out.println("Default faculty (Unknown, 35, Unknown, false)");
			System.out.println("" + f1);
	
			printBlank();
			Faculty f2 = new Faculty("Dr. Sobel");
			System.out.println("Named faculty (Dr. Sobel, 35, Unknown, false)");
			System.out.println("" + f2);
			
			printBlank();
			Faculty f3 = new Faculty("Dr. Zmuda", 31, "CS", true);
			System.out.println("Fully-defined faculty (Dr. Zmuda, 31, CS, true)");
			System.out.println("" + f3);
		
		printStars();
		System.out.println("Testing speaking");
		
			printBlank();
			System.out.println("A person speaks:");
			p1.speak();
			
			printBlank();
			System.out.println("A student speaks:");
			s1.speak();
			
			printBlank();
			System.out.println("A graduate student speaks:");
			g1.speak();
			
			printBlank();
			System.out.println("A faculty member speaks:");
			f1.speak();
	
		printStars();
		System.out.println("Testing graduate student grading");
		
			printBlank();
			System.out.println("A graduate student grades Prelim 1:");
			g1.grade("Prelim 1");
			
			printBlank();
			System.out.println("A graduate student grades a lab with a max of 10:");
			int lab1 = g1.grade("Lab", 10);
			
			printBlank();
			System.out.println("A graduate student regrades the lab:");
			g1.regrade("Lab", lab1);
					
		printStars();
		System.out.println("Testing faculty member grading");
		
			printBlank();
			System.out.println("A faculty member grades Prelim 1:");
			f1.grade("Prelim 1");
			
			printBlank();
			System.out.println("A faculty member grades a lab with a max of 10:");
			int lab2 = f1.grade("Lab", 10);
			
			printBlank();
			System.out.println("A faculty member regrades the lab:");
			f1.regrade("Lab", lab2);
			
			printBlank();
			System.out.println("A faculty member regrades a score of 0:");
			f1.regrade("Zero", 0);
	}

	public static void printStars() {
		System.out.println("*********************************************************************");
	}
	
	public static void printBlank() {
		System.out.println();
	}
	
	public static int random(int min, int max) {
		return (int) (Math.random() * (max - min + 1) + min);
	}

}