/**
 * GraduateStudent - Lab 9
 * A graduate student at a university
 * Author: Michael Clarkson
 * NetID: mrc26
 * Date: 7/27/00
 */
class GraduateStudent extends Student implements Grader {
	
	/**
	 * Graduate students are associated with a department
	 */
	String department = "Unknown";
	
	/**
	 * Default constructor, create a graduate student
	 * with default attributes.
	 */
	GraduateStudent() {
		age = 25;
	}
	
	/**
	 * Create a graduate student with the given name and default age,
	 * department, and gpa
	 */
	GraduateStudent(String name) {
		this.name = name;
		this.age = 25;
	}

	/**
	 * Create a graduate student with the given name, age, department,
	 * and gpa.
	 */
	GraduateStudent(String name, int age, String department, double gpa) {
		this.name = name;
		this.age = age;
		this.department = department;
		this.gpa = gpa;
	}
	
	/**
	 * Graduate students give grades from 70% - 100%
	 */
	public int grade(String assignment) {
		return grade(assignment, 100);
	}
	
	/**
     * Graduate students give grades from 70% - 100% of maxPoints
	 */
	public int grade(String assignment, int maxPoints) {
		int g = University.random((int) (.7 * maxPoints), maxPoints); 
		System.out.println("Grade on " + assignment + " is " + g);
		return g;
	}
	
	/**
	 * Graduate students increase grade by 1-10 points
	 */
	public int regrade(String assignment, int prevGrade) {
		int adj = University.random(1, 10);
		int newGrade = prevGrade + adj;
		System.out.println("Grade on " + assignment + " is changed from " + prevGrade + " to " + newGrade);
		return newGrade;
	}
	
	/**
	 * Graduate students speak about their major concern
	 */
	public void speak() {
		System.out.println("What's that have to do with my thesis?");
	}
	
	/**
	 * Return all the attributes of a graduate student as a String
	 */
	public String toString() {
		return "Graduate student: name = " + name + ", age = " + age + ", department = " + department + ", gpa = " + gpa;
	}
}