/**
 * Faculty - Lab 9
 * A faculty member at a university
 * Author: Michael Clarkson
 * NetID: mrc26
 * Date: 7/27/00
 */
class Faculty extends Person implements Grader {

	/**
	 * Is the faculty member tenured?
	 */
	boolean tenured = false;
	
	/**
	 * Department the faculty member is affiliated with
	 */
	String department = "Unknown";

	/**
	 * Default constructor, create a faculty member with the
	 * default attributes
	 */
	public Faculty() {
		age = 35;	
	}

	/**
	 * Create a faculty member with the given name and default
	 * age, department, and tenure status
	 */
	public Faculty(String name) {
		this.name = name;
		age = 35;
	}

	/**
	 * Create a faculty member with the given name,
	 * age, department, and tenure status
	 */
	public Faculty(String name, int age, String department, boolean tenured) {
		this.name = name;
		this.age = age;
		this.department = department;
		this.tenured = tenured;
	}
	
	/**
	 * Faculty assign random grades between 0% and 70%
	 */
	public int grade(String assignment) {
		return grade(assignment, 100);
	}
	
	/**
	 * Faculty assign random grades between 0% and 70% of maxPoints
	 */
	public int grade(String assignment, int maxPoints) {
		int g = University.random(0, (int) (.7 * maxPoints)); 
		System.out.println("Grade on " + assignment + " is " + g);
		return g;
	}
	
	/**
	 * Faculty randomly reduce the score from 1 to 10 points, but
	 * not below 0.
	 */
	public int regrade(String assignment, int prevGrade) {
		int adj = University.random(1, 10);
		int newGrade = prevGrade - adj;
		if (newGrade < 0) {
			newGrade = 0;
		}
		System.out.println("Grade on " + assignment + " is changed from " + prevGrade + " to " + newGrade);
		return newGrade;
	}
	
	/**
	 * Faculty speak encouragingly
	 */
	public void speak() {
		System.out.println("Have fun; work hard.");
	}
	
	/**
	 * Returns the attributes of a faculty member as a String
	 */
	public String toString() {
		return "Faculty: name = " + name + ", age = " + age + ", department = " + department + ", tenured = " + (tenured ? "yes" : "no");
	}
}