function yhat=knn(x,y,xstar,k,dist)
    if nargin < 5
        dist = @(x1,x2) norm(x1-x2);
    end
    [m, p] = size(x);
    [mstar, pstar] = size(xstar);
    yhat = zeros(mstar,1);
    if p ~= pstar 
        fprintf(2,'dimensions do not match');
        return
    end
    d = zeros(m,1);
    for j=1:mstar
        t=xstar(j,:);
        for i=1:m
            d(i) = dist(t,x(i,:));
        end
        [ds, di] = sort(d);
        s = di(1:k);
        yhat(j)=((1./d(s))/sum(1./d(s)))'*y(s);
    end
end
